# -*- coding: utf-8 -*-

GLADEFILE = "vi-python.glade"

import WIDGET, TAB, Dialog

def on_show_popup_TAB (obj, event, STATE) :

	if event.button == 3 :
		inTAB(event, state=STATE)

def on_show_popup_VTE (obj, event, STATE) :

	if event.button == 3 :
		inVTE(event, state=STATE)

class inVTE (WIDGET.WIDGET) :

	STATE = None

	def __init__ (self, event, **kwargs) :

		if not kwargs.has_key("state") :
			raise ValueError, "State must be included."
		else :
			self.STATE = kwargs["state"]

		handler = { \
			"on_add_vim" : self.on_add_vim, \
			"on_add_console" : self.on_add_console, \
			"on_preferences" : self.on_preferences, \
			\
			"on_show_toolbar" : self.on_show_toolbar, \
			"on_show_menubar" : self.on_show_menubar, \
		}

		WIDGET.WIDGET.__init__(self, GLADEFILE, "menu1", None)

		self.WIDGET_SELF.popup(None,None,None,event.button,event.time)

		# set the current state.
		for i in self.WIDGET_SELF.get_children() :
			if i.get_property("name") == "show_toolbar" :
				i.set_property( \
					"active", self.STATE.DATA["toolbar"].get_property("visible"))

			if i.get_property("name") == "show_menubar" :
				i.set_property( \
					"active", self.STATE.DATA["menubar"].get_property("visible"))

		self.xml.signal_autoconnect(handler)

	def on_add_vim (self, widget) :
		pass

	def on_add_console (self, widget) :
		pass

	def on_preferences (self, widget) :
		Dialog.Preference()

	def on_show_toolbar (self, widget) :
		__toolbar = self.STATE.DATA["toolbar"]
		if __toolbar.get_property("visible") :
			__toolbar.hide()
		else :
			__toolbar.show()

	def on_show_menubar (self, widget) :
		__menubar = self.STATE.DATA["menubar"]
		if __menubar.get_property("visible") :
			__menubar.hide()
		else :
			__menubar.show()

class inTAB (WIDGET.WIDGET) :

	STATE = None

	def __init__ (self, event, **kwargs) :

		if not kwargs.has_key("state") :
			raise ValueError, "State must be included."
		else :
			self.STATE = kwargs["state"]

		handler = { \
			"on_show_toolbar" : self.on_show_toolbar, \
			"on_show_menubar" : self.on_show_menubar, \
		}

		WIDGET.WIDGET.__init__(self, GLADEFILE, "menu2", None)

		self.WIDGET_SELF.popup(None,None,None,event.button,event.time)

		# set the current state.
		for i in self.WIDGET_SELF.get_children() :
			if i.get_property("name") == "show_toolbar" :
				i.set_property( \
					"active", self.STATE.DATA["toolbar"].get_property("visible"))

			if i.get_property("name") == "show_menubar" :
				i.set_property( \
					"active", self.STATE.DATA["menubar"].get_property("visible"))

		self.xml.signal_autoconnect(handler)

	def on_show_toolbar (self, widget) :
		__toolbar = self.STATE.DATA["toolbar"]
		if __toolbar.get_property("visible") :
			__toolbar.hide()
		else :
			__toolbar.show()

	def on_show_menubar (self, widget) :
		__menubar = self.STATE.DATA["menubar"]
		if __menubar.get_property("visible") :
			__menubar.hide()
		else :
			__menubar.show()

"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Menu.py"


