# -*- coding: utf-8 -*-
import os
import gconf

import Conf, TAB

class Client :

	CLIENT = None

	def __init__ (self) :

		self.CLIENT = gconf.client_get_default();

	def add_dir (self, path) :
		self.CLIENT.add_dir(os.path.dirname(path), gconf.CLIENT_PRELOAD_NONE)

	def set_path (self, path, make_new=False) :
		path = os.path.dirname(path)

		if not self.CLIENT.dir_exists(path) :
			if make_new :
				return self.create_new(path)
			else :
				raise ValueError, "%s does not exists." % path

		else :
			return True

	def get_value (self, key, typeValue=None) :

		if not self.CLIENT.dir_exists(os.path.dirname(key)) :
			return False

		if typeValue == "int_list" :
			return self.get_list(key, "int")

		__value = self.CLIENT.get(key)

		return self.get_value_from_value(__value)

	def get_value_from_value (self, GConfValue) :
		if not isinstance(GConfValue, gconf.Value) :
			#raise ValueError, "GConfValue must be instance of gconf.Value"
			return ""

		__type = GConfValue.type

		if __type == gconf.VALUE_INT :
			__v = GConfValue.get_int()
		elif __type == gconf.VALUE_BOOL :
			__v = GConfValue.get_bool()
		elif __type == gconf.VALUE_STRING :
			__v = GConfValue.get_string()
		else :
			__v = None

		return __v

	def set_value (self, typeValue, key, value, set_force=False) :

		if not self.CLIENT.dir_exists(os.path.dirname(key)) :
			if set_force :
				if not self.create_new(os.path.dirname(key)) :
					return False
			else :
				return False

		if typeValue == "int" :
			self.CLIENT.set_int(key, value)
		elif typeValue == "bool" :
			self.CLIENT.set_bool(key, value)
		elif typeValue == "string" :
			self.CLIENT.set_string(key, value)
		elif typeValue == "int_list" :
			return self.set_list("int", key, value, set_force)
		else :
			return False

		return True

	def get_list (self, typeValue, key) :

		if typeValue == "int" :
			__type = gconf.VALUE_INT
		elif typeValue == "bool" :
			__type = gconf.VALUE_BOOL
		elif typeValue == "string" :
			__type = gconf.VALUE_STRING
		else :
			return False

		return self.CLIENT.get_list(key, __type)

	def set_list (self, typeValue, key, list_value, set_force=False) :
		if not self.CLIENT.dir_exists(os.path.dirname(key)) :
			if set_force :
				if not self.create_new(os.path.dirname(key)) :
					return False
			else :
				return False

		if type(list_value) is not (list or tuple) :
			return False

		if typeValue == "int" :
			__type = gconf.VALUE_INT
		elif typeValue == "bool" :
			__type = gconf.VALUE_BOOL
		elif typeValue == "string" :
			__type = gconf.VALUE_STRING
		else :
			return False

		return self.CLIENT.set_list(key, __type, list_value)

class Notify :

	NOTIFY_ID = dict()
	GCONF_CLIENT = None
	STATE = None

	def __init__ (self, gconf_client, **kwargs) :

		self.GCONF_CLIENT = gconf_client

		if not kwargs.has_key("state") :
			raise ValueError, "State must be included."
		else :
			self.STATE = kwargs["state"]

		self.notify()

	def notify (self) :

		notify_id = self.GCONF_CLIENT.CLIENT.notify_add( \
			Conf.SCHEMA["show-toolbar"]["key"], self.on_toggle_toolbar)

		notify_id = self.GCONF_CLIENT.CLIENT.notify_add( \
			Conf.SCHEMA["show-menubar"]["key"], self.on_toggle_menubar)

		notify_id = self.GCONF_CLIENT.CLIENT.notify_add( \
			Conf.SCHEMA["font-vim"]["key"], self.on_font_vim)
		notify_id = self.GCONF_CLIENT.CLIENT.notify_add( \
			Conf.SCHEMA["font-console"]["key"], self.on_font_console)

	def on_font_vim (self, client, parm1, parm2, parm3) :
		__font = self.GCONF_CLIENT.get_value_from_value(parm2.get_value())

		list_vim_tab = list()
		for i in self.STATE.DATA["tab-list"] :
			if i.VTE.VTE_TYPE == TAB.VTE_TYPE_VIM :
				list_vim_tab.append(i.VTE)

		for i in list_vim_tab :
			i.set_font_from_string(__font)

	def on_font_console (self, client, parm1, parm2, parm3) :
		__font = self.GCONF_CLIENT.get_value_from_value(parm2.get_value())

		list_vim_tab = list()
		for i in self.STATE.DATA["tab-list"] :
			if i.VTE.VTE_TYPE == TAB.VTE_TYPE_CONSOLE :
				list_vim_tab.append(i.VTE)

		for i in list_vim_tab :
			i.set_font_from_string(__font)

	def on_toggle_menubar (self, client, parm1, parm2, parm3) :
		__is_activate = self.GCONF_CLIENT.get_value_from_value(parm2.get_value())

		if __is_activate :
			self.STATE.DATA["menubar"].show()
		else :
			self.STATE.DATA["menubar"].hide()

	def on_toggle_toolbar (self, client, parm1, parm2, parm3) :
		__is_activate = self.GCONF_CLIENT.get_value_from_value(parm2.get_value())

		if __is_activate :
			self.STATE.DATA["toolbar"].show()
		else :
			self.STATE.DATA["toolbar"].hide()


"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "GConf.py"

