# -*- coding: utf-8 -*-

# GLOBAL configuration values.
GLOBAL_FONT_SYSTEM_DEFAULT		= "/desktop/gnome/interface/monospace_font_name"

# LOCAL configuration values.
LOCAL_ROOT									=	"/apps/vi-python/"
SCHEMA_ROOT									=	"/schemas/apps/vi-python/"

SCHEMA = {
	"use-system-default-font" : {
		"key" : LOCAL_ROOT + "use_system_default_font",
		"schema" : SCHEMA_ROOT + "use_system_default_font",
		"type" : "bool",
		"default" : True,
	},

	"font-vim" : {
		"key" : LOCAL_ROOT + "vim_font",
		"schema" : SCHEMA_ROOT + "vim_font",
		"type" : "string",
		"default" : "Monospace 16",
	},

	"font-console" : {
		"key" : LOCAL_ROOT + "console_font",
		"schema" : SCHEMA_ROOT + "console_font",
		"type" : "string",
		"default" : "Monospace 16",
	},

	"show-menubar" : {
		"key" : LOCAL_ROOT + "show_menubar",
		"schema" : SCHEMA_ROOT + "show_menubar",
		"type" : "bool",
		"default" : True,
	},

	"show-toolbar" : {
		"key" : LOCAL_ROOT + "show_toolbar",
		"schema" : SCHEMA_ROOT + "show_toolbar",
		"type" : "bool",
		"default" : True,
	},

	"command-vim" : {
		"key" : LOCAL_ROOT + "vim_command",
		"schema" : SCHEMA_ROOT + "vim_command",
		"type" : "string",
		"default" : "vim",
	},

	"command-console" : {
		"key" : LOCAL_ROOT + "console_command",
		"schema" : SCHEMA_ROOT + "console_command",
		"type" : "string",
		"default" : "bash",
	},

	"color-foreground" : {
		"key" : LOCAL_ROOT + "foreground_color",
		"schema" : SCHEMA_ROOT + "foreground_color",
		"type" : "int_list",
		"default" : [65535,65535,65535,0],
	},

	"color-background" : {
		"key" : LOCAL_ROOT + "background_color",
		"schema" : SCHEMA_ROOT + "background_color",
		"type" : "int_list",
		"default" : [0,0,0,0],
	},
}

import GConf, gconf

def verify () :
	"""
	Check whether key and it's type is correct or not, if not insert
	new schema.
	"""

	try :
		GCONF_CLIENT = GConf.Client()
		GCONF_CLIENT.set_path(LOCAL_ROOT)
	except :
		install_schema()
	else :
		if not isinstance(GCONF_CLIENT.CLIENT.get_schema( \
				SCHEMA["use-system-default-font"]["schema"]), gconf.Schema) :
			install_schema()

def install_schema () :

	import os, time

	a, b, c = os.popen3('gconftool-2 --install-schema-file=vi-python.schema')

	if len(c.readlines()) > 0 :
		print ">> Failed to install Schema file."

		return

	print ">> Install Schema file."
	print ""

	time.sleep(2)

	return True

"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Conf.py"


