# -*- coding: utf-8 -*-
import sys, os

import pygtk
pygtk.require("2.0")

try :
	import gtk
	import gtk.glade
	import gobject
	import pango
except :
	print "you need to instal pygtk or GTKv2."
	sys.exit(1)

import vte

import Label, GConf, Conf

class TAB :

	NOTEBOOK = None
	WIDGET_ROOT = None

	INSTANCE_LABEL = None
	INSTANCE_SCROLLEDWINDOW = None

	STR_TAB_NAME = "None"

	STATE = None
	WITHOUT_CLOSEBUTTON = False

	def __init__ (self, notebook, **kwargs) :

		self.NOTEBOOK = notebook
		self.WIDGET_ROOT = self.NOTEBOOK.get_root_window()

		if not kwargs.has_key("state") :
			raise ValueError, "State must be included."
		else :
			self.STATE = kwargs["state"]

		if kwargs.has_key("without_closebutton") :
			self.WITHOUT_CLOSEBUTTON = kwargs["without_closebutton"]

	def on_signal_remove_tab (self, widget) :

		currnet_page = self.NOTEBOOK.get_current_page()
		self.NOTEBOOK.remove_page(currnet_page)

	def addLabel (self, label) :

		if not isinstance(label, gtk.Widget) :
			raise ValueError, "label must be the subclass of gtk.Widget."

		self.INSTANCE_LABEL = label

	def __makeLabel (self) :

		if not self.INSTANCE_LABEL :
			self.INSTANCE_LABEL = Label.TabWithClose( \
				state=self.STATE, \
				without_closebutton=self.WITHOUT_CLOSEBUTTON)

			self.INSTANCE_LABEL.show()

	#########################################################
	# VTE
	def connectSignalVTE (self) :
		self.VTE.VTE.connect("child-exited", self.on_signal_remove_tab)

	def addVTE (self, vte) :

		if not isinstance(vte, VTE) :
			raise ValueError, "vte must be instance of VTE class."

		self.VTE = vte
		self.connectSignalVTE()

		self.__makeLabel()

		# create scrolled window
		self.INSTANCE_SCROLLEDWINDOW = gtk.ScrolledWindow()
		self.INSTANCE_SCROLLEDWINDOW.set_policy( \
			gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

		self.INSTANCE_SCROLLEDWINDOW.set_border_width(0)
		self.INSTANCE_SCROLLEDWINDOW.set_shadow_type(gtk.SHADOW_NONE)
		self.INSTANCE_SCROLLEDWINDOW.set_property("can-focus", True)
		self.INSTANCE_SCROLLEDWINDOW.set_property("has-focus", True)

		self.INSTANCE_SCROLLEDWINDOW.add_with_viewport(self.VTE.VTE)
		self.INSTANCE_SCROLLEDWINDOW.show()

		# add ScrolledWindow in notebook
		self.INSTANCE_LABEL.registerVTE(self.VTE)
		self.NOTEBOOK.append_page( \
			self.INSTANCE_SCROLLEDWINDOW, self.INSTANCE_LABEL)

		# focus in VTE.
		self.NOTEBOOK.set_current_page(self.NOTEBOOK.get_n_pages() - 1)
		vte.VTE.grab_focus()

	def addWidget (self, widget, labelname=None) :

		if not isinstance(widget, gtk.Widget) :
			raise ValueError, "widget must be instance of gtk.Widget class."

		self.INSTANCE_LABEL = Label.TabWithClose( \
			state=self.STATE, filename=labelname, \
			without_closebutton=self.WITHOUT_CLOSEBUTTON)
		self.INSTANCE_LABEL.show()

		self.NOTEBOOK.append_page( \
			widget, self.INSTANCE_LABEL)

		# focus in VTE.
		self.NOTEBOOK.set_current_page(self.NOTEBOOK.get_n_pages() - 1)

# constanct
VTE_TYPE_CONSOLE = 1
VTE_TYPE_VIM = 2

class VTE :

	VTE = None

	VTE_TYPE = VTE_TYPE_VIM

	DEFAULT_FONTNAME = "Bitstream Vera Sans Mono 16"
	EMULATION = "xterm"
	FILENAME = str()
	DIRECTORY = str()
	FORK_COMMAND = str()
	UNIT_FONT_DELM = 1000
	RANGE_FONT_SIZE = (10000, 30000)

	def __init__ (self, **kwargs) :
		if kwargs.has_key("filename") :
			if os.path.exists(kwargs["filename"]) :
				self.FILENAME = kwargs["filename"]

		if not kwargs.has_key("command") and not self.FORK_COMMAND :
			raise ValueError, "command argument must be needed."
		elif kwargs.has_key("command") :
			self.FORK_COMMAND = kwargs["command"]

		if kwargs.has_key("directory") :
			if os.path.isdir(kwargs["directory"]) :
				self.DIRECTORY = kwargs["directory"]

		self.GCONF_CLIENT = GConf.Client()

	def reset (self) :
		self.reset_vte()
		self.VTE.reset(True, True)
		#self.VTE.feed_child("")
		#self.VTE.feed_child("")

	def set_font_from_string (self, fontname) :
		self.VTE.set_font_from_string(fontname)
		self.reset()

	def set_font (self, fontDescription) :
		self.VTE.set_font(fontDescription)
		self.reset()

	def decrease_font (self, size=int()) :

		pd = self.VTE.get_font()

		__s = pd.get_size() - self.UNIT_FONT_DELM
		if __s not in \
				range(self.RANGE_FONT_SIZE[0], self.RANGE_FONT_SIZE[1]) :
			return

		pd.set_size(__s)
		self.VTE.set_font(pd)
		self.reset()

		return

	def increase_font (self, size=int()) :

		pd = self.VTE.get_font()

		__s = pd.get_size() + self.UNIT_FONT_DELM
		if __s not in \
				range(self.RANGE_FONT_SIZE[0], self.RANGE_FONT_SIZE[1]) :
			return

		pd.set_size(__s)
		self.VTE.set_font(pd)
		self.reset()

		return

	def make (self) :
		self.VTE = vte.Terminal()

		self.VTE.set_audible_bell(False)
		self.VTE.set_visible_bell(True)
		self.VTE.set_scroll_on_output(False)

		self.VTE.connect("char-size-changed", self.reset_vte)
		self.reset()
		__pd = pango.FontDescription(self.DEFAULT_FONTNAME)
		self.VTE.set_font(__pd)
		self.VTE.set_emulation(self.EMULATION)

		# get colormap
		__color_fore = \
			self.GCONF_CLIENT.get_list("int", Conf.LOCAL_COLOR_FOREGROUND)
		__color_back = \
			self.GCONF_CLIENT.get_list("int", Conf.LOCAL_COLOR_BACKGROUND)

		self.VTE.set_color_foreground( \
			gtk.gdk.Color( \
				__color_fore[0], \
				__color_fore[1], \
				__color_fore[2], \
			) \
		)

		self.VTE.set_color_background( \
			gtk.gdk.Color( \
				__color_back[0], \
				__color_back[1], \
				__color_back[2], \
			) \
		)

		self.VTE.show()

		ID = self.VTE.fork_command( \
			command=self.FORK_COMMAND, \
			argv=[self.FILENAME,], \
			directory=self.DIRECTORY \
		)

	def reset_vte (self, parm1=None, parm2=None, parm3=None) :
		self.VTE.set_size(5,5)

	def exit (self) :
		"""
		the method to safely exited.
		"""
		self.VTE.destroy()

class VTE_VIM (VTE) :

	VTE_TYPE = VTE_TYPE_VIM
	FORK_COMMAND = "vi-bin"

	def make (self) :
		if self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_USE_SYSTEM_DEFAULT) :
			self.DEFAULT_FONTNAME = \
				self.GCONF_CLIENT.get_value(Conf.GLOBAL_FONT_SYSTEM_DEFAULT)
		else :
			self.DEFAULT_FONTNAME = \
				self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_VIM)

		self.FORK_COMMAND = self.GCONF_CLIENT.get_value(Conf.LOCAL_COMMAND_VI)

		VTE.make(self)

		if self.FILENAME :
			self.VTE.feed_child(":e %s\n" % self.FILENAME.replace(" ", "\\ "))

	def exit (self) :
		self.VTE.feed_child(":q\n")

class VTE_CONSOLE (VTE) :

	VTE_TYPE = VTE_TYPE_CONSOLE
	FORK_COMMAND = "/bin/bash"
	FILENAME = "-l"

	def make (self) :
		if self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_USE_SYSTEM_DEFAULT) :
			self.DEFAULT_FONTNAME = \
				self.GCONF_CLIENT.get_value(Conf.GLOBAL_FONT_SYSTEM_DEFAULT)
		else :
			self.DEFAULT_FONTNAME = \
				self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_CONSOLE)

		self.FORK_COMMAND = self.GCONF_CLIENT.get_value(Conf.LOCAL_COMMAND_CONSOLE)

		VTE.make(self)

	def exit (self) :
		self.VTE.feed_child("\n")
		self.VTE.feed_child("exit\n")

"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "TAB.py"

