/*
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

Alternatively, the contents of this file may be used under the
terms of the GNU General Public License Version 2 or later (the
"GPL"), in which case the provisions of the GPL are applicable 
instead of those above.

Copyright (C) 2002 Tomas Styblo <tripie@cpan.org>
*/

var mozex_prefs = Components.classes["@mozilla.org/preferences-service;1"].
    getService(Components.interfaces.nsIPrefService).getBranch("mozex.");

function mozexReadPref(name) {
    if (mozex_prefs.prefHasUserValue(name)) {
        var type = mozex_prefs.getPrefType(name);
        if (type & 128) {
            return mozex_prefs.getBoolPref(name);
        }
        else if (type & 64) {
            return mozex_prefs.getIntPref(name);
        }
        else if (type & 32) {
            return mozex_prefs.getCharPref(name);
        }
        else {
            return null;
        }
    }
    else {
        return null;
    }
}

function initMozexPref() {
    document.getElementById("prefMozexInterceptMailto").checked = 

        mozexReadPref("intercept.mailto");
    document.getElementById("prefMozexInterceptNews").checked = 
        mozexReadPref("intercept.news");
    document.getElementById("prefMozexInterceptTelnet").checked = 
        mozexReadPref("intercept.telnet");
    document.getElementById("prefMozexInterceptFtp").checked = 
        mozexReadPref("intercept.ftp");
    document.getElementById("prefMozexTmpdir").value = 
        mozexReadPref("general.tmpdir");
    document.getElementById("prefMozexMailer").value = 
        mozexReadPref("command.mailer");
    document.getElementById("prefMozexSourceViewer").value = 
        mozexReadPref("command.source");
    document.getElementById("prefMozexTextareaEditor").value = 
        mozexReadPref("command.textarea");
    document.getElementById("prefMozexNewsClient").value = 
        mozexReadPref("command.news");
    document.getElementById("prefMozexTelnetClient").value = 
        mozexReadPref("command.telnet");
    document.getElementById("prefMozexFTPClient").value = 
        mozexReadPref("command.ftp");
    document.getElementById("prefMozexDownloadClient").value = 
        mozexReadPref("command.download");
    document.getElementById("prefMozexED2KClient").value = 
        mozexReadPref("command.ed2k");
}

function initMozexPrefPanel() {
    parent.initPanel('chrome://mozex/content/pref-mozex.xul');
    initMozexPref();
}

function changeMozexPrefs() {
    mozex_prefs.setBoolPref("intercept.mailto", 
        document.getElementById("prefMozexInterceptMailto").checked);
    mozex_prefs.setBoolPref("intercept.news", 
        document.getElementById("prefMozexInterceptNews").checked);
    mozex_prefs.setBoolPref("intercept.telnet", 
        document.getElementById("prefMozexInterceptTelnet").checked);
    mozex_prefs.setBoolPref("intercept.ftp", 
        document.getElementById("prefMozexInterceptFtp").checked);
    mozex_prefs.setCharPref("general.tmpdir", 
        document.getElementById("prefMozexTmpdir").value);
    mozex_prefs.setCharPref("command.mailer", 
        document.getElementById("prefMozexMailer").value);
    mozex_prefs.setCharPref("command.source", 
        document.getElementById("prefMozexSourceViewer").value);
    mozex_prefs.setCharPref("command.textarea", 
        document.getElementById("prefMozexTextareaEditor").value);

    mozex_prefs.setCharPref("command.news", 
        document.getElementById("prefMozexNewsClient").value);
    mozex_prefs.setCharPref("command.telnet", 
        document.getElementById("prefMozexTelnetClient").value);
    mozex_prefs.setCharPref("command.ftp", 
        document.getElementById("prefMozexFTPClient").value);
    mozex_prefs.setCharPref("command.download", 
        document.getElementById("prefMozexDownloadClient").value);
    mozex_prefs.setCharPref("command.ed2k", 
        document.getElementById("prefMozexED2KClient").value);
}
