<?php

/**

///////////////////////  H3Z2 ENCODE ///////////////////////

// @ : 2006 11 13
// @ : 2008-8-18
// @ : ŵ  <.)++++<  budl 
// @ : ikw3179@naver.com
// @۱ : GPL

// @H3Z2 ڵĿ   ũ : http://wiki.kldp.org/wiki.php/H3Z2

H3Z2 ڵ  ؽƮ Ǵ ̳ʸ  پ 뵵   ֵ ϱ  
ؽƮ ڵ Դϴ.  ڿ(̳ʸ) 2byte   2byte( 0 ~ 65535 ) 
3 Ǵ 2 ĺ ȯ ݴϴ. 

                 ///////////////////////////////////////////////////
               ////            36 * 36 * 50 + 16 * 46 = 65536              ////
             ///////////////////////////////////////////////////

            ǥ : [H-Y]{2}[A-Y]|[ZA-G][A-W]
 

 H3Z2  base64  ؽƮ ڵ ٸ  ĺ Ѵٴ  ڵ 
 ڿ  پ 뵵 밡ϰ ˴ϴ. 16 ڵ  2byte 4 ڷ 
 ǥϴµ  H3Z2 2 Ǵ 3  ڷ ǥϹǷ  ȿ  ֽϴ.
 
 ////////////////////////////////////////////////////////////////
 
*/

define ( H3Z2_DIV, 736 ); // Ӱ谪 

//---------------12345678901234567890123456789012345678901234567890-----------//

$H3Z2[H]= "HhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYy" ;
$H3Z2[Z]= "ZzAaBbCcDdEeFfGg" ;
$H3Z2[A]= "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"   ;
$H3Z2_D = array() ;

class  h3z2code
{	
////-------------  ENCODE ---------------/////

	function	encode( $input )
	{		
		//ڿΰ ڹ迭 ȯ 
		if( is_string( $input ))
		{				
			//Ȧ ũ ڿ   1 Ʈ C ( unsigned char )  ǴϿ  ٲ۴.
			if( strlen( $input ) %2 )
					$input = unpack( "v*/C1x" , $input );
			else	$input = unpack( 'v*' , $input );
		}
		
	    if ( is_array( $input ) ) // 迭
	    {
			foreach( $input as $a )
				h3z2code::encode_core( $Rstr , $a ) ;
	    }
	    else if ( is_int ( $input )) // 
			h3z2code::encode_core( $Rstr , $input ) ;			
	  
	    else  trigger_error("Է°( $input ) ȿ  [".__FUNCTION__."]", E_USER_ERROR );
		
		return $Rstr ;
	}
	
	//$rstr   ߰!!
	function encode_core( &$rstr , $codeVal )
	{
		global  $H3Z2 ;

		if( $codeVal < 0  ||  $codeVal >= 65536 ) 
		trigger_error("谪( 0 ~ 65535 )  ġ \$codeVal = $codeVal [".__FUNCTION__."]", E_USER_ERROR );


		if( $codeVal < H3Z2_DIV  ) // $codeVal < 736 ; 
		{
		  $rstr  .=  $H3Z2[Z][ intval( $codeVal / 46 ) ].
					  $H3Z2[A][ $codeVal %46  ] ;
		}
		else {  // >= 736
		$codeVal  -=  H3Z2_DIV  ;

		$midVal  = intval( $codeVal / 1800 );// 1800 = 36*50
		$midRem  = $codeVal % 1800   ;

		$rstr  .=   $H3Z2[H][ $midVal   ]. 
					$H3Z2[H][ intval( $midRem / 50 ) ].  
					$H3Z2[A][ $midRem % 50  ] ;
		}  
		//return 1 ; 

	} // function c3encode_subfunc ; 
	
	
////-------------  DECODE ---------------/////

	/// @function decode  H3Z2 ڿ  迭 Ǵ  ڿ ȯѴ.
	/// $mode  1 Ǵ 2 Ǹ ̳ʸ ڿ ȯϴ  
	/// 1 ̸  ιڸ ϰ 2̸  ʴ´.
	/// 0 ̸ 迭 ȯѴ.
	function 	decode( $h3z2str , $mode = 1  )
	{		    
		$Rary = array() ;
		$R = "" ; 	  
	  
		for($i = 0 ;  
			// (.)  ġ ʴ κ ġϴ  
			//\Gɼ Ͽ ڿ ۺκ ġǵؾ Ѵ. ^ Ҽ .
			preg_match( "/\G(?:[H-Y]{2}[A-Y]|[ZA-G][A-W]|(.))/i" , $h3z2str , $match , 0 , $i ) ;
			$i += strlen( $match[0] ) )
		{	  
			if( $match[1] ){
				
				trigger_error("Է H3Z2ڵ( $h3z2str , $i:$match[1] ) Ͽ  [".__FUNCTION__."]" , E_USER_ERROR ) ;	  
			}
		    
		    $ecode  = $match[0] ;
			
		    $dcode  = h3z2code::decode_core( $ecode )  ;	    
		    
		    switch( $mode )
		    {
		      case 0 : array_push( $Rary , $dcode ) ;  break ; 
		      
		      // ̳ʸ  little endian  ȯ !!
			  case 1 :  
		      case 2 : $R .= pack( "v" , $dcode );  break ; 
			}
		}
	  
		switch( $mode )
		{
			case 0 :   return $Rary  ; 	    
		
			//   ڰ NULL ̸ Ѵ.
			case 1 :   return  rtrim( $R , "\0" ); 
			case 2 :   return $R ;
		}
		;
	} // function decode  
	  
	  
	function decode_init( )
	{
		if( $H3Z2_D ) return ; 
		
		global  $H3Z2  , $H3Z2_D ;  

		$H3Z2_D[H] = array();
		$H3Z2_D[Z] = array();
		$H3Z2_D[A] = array();

		foreach( $H3Z2 as  $key => $val )
		{
			for( $i = 0 ; $i < strlen($H3Z2[$key]); $i++ )
			{
			  $H3Z2_D[$key][$val[$i]] = $i ; 
			}  
		}
	}

	function decode_core( $ecode )
	{  
		h3z2code::decode_init( ); 
		
		global  $H3Z2_D  ;	

		$rVal = 0 ; 

		if( preg_match( "/^([ZA-G])(.)/i" , $ecode  , $mch ) )
		{
			$rVal =   $H3Z2_D[Z][$mch[1]]*46 
					  + $H3Z2_D[A][$mch[2]] ; 
		}
		else if( preg_match( "/^([H-Y])([H-Y])(.)/i" , $ecode  , $mch ) )
		{
			$rVal =   $H3Z2_D[H][$mch[1]]*1800 
					+ $H3Z2_D[H][$mch[2]]*50
					+ $H3Z2_D[A][$mch[3]] 
					+ H3Z2_DIV ; // 736 
		}
		else
		{
			trigger_error("Է H3Z2ڵ( $ecode ) Ͽ  [".__FUNCTION__."]" , E_USER_ERROR ) ;
		}
		return  $rVal ;
	}

}//class  h3z2code
