#include <gio/gio.h>
#include <stdio.h>
#include <string.h>


int main(int argc, char** argv)
{
  g_type_init();

  GFile* file = g_file_new_for_path("test_output.txt");

  GFileOutputStream* stream = NULL;

  const gchar* contents = NULL;

  //If the file exists already then replace it.
  //Otherwise, create it:
  GError *error = NULL;
  if(g_file_query_exists(file, NULL))
  {
    stream = g_file_replace(file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &error);
    contents = "Replaced contents.";
  }
  else
  {
    stream = g_file_create(file, G_FILE_CREATE_NONE, NULL, &error);
    contents = "Original contents.";
  }

  if(error)
  {
    g_printf("GError: %s\n", error->message);
    g_clear_error(&error);
  }
   

  if(!stream)
    g_printf("stream is NULL\n");


  error = NULL;
  const gsize bytes_read = g_output_stream_write(G_OUTPUT_STREAM(stream), contents, strlen(contents), NULL, &error);

  if(error)
  {
    g_printf("GError: %s\n", error->message);
    g_clear_error(&error);
  }
    
  if(bytes_read)
    g_printf("File contents written: %s\n", contents);
  else
    g_printf("Gio::InputStream::write() wrote 0 bytes.");

  return 0;
}

