#! /usr/bin/perl -w

###################################################################################
#   this file is part of c2h
#   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###################################################################################/

foreach( @ARGV ){
    if( /(\w+).txt/)
    {
	$f_name = $1;
    }
    open INPUT, "<".$_
	or die "can't open $_\n";
    open OUTPUT, ">".$f_name.".h"
	or die "can't open $f_name.h\n";

    $f_name = uc($f_name);

    print OUTPUT "#ifndef   "."_".$f_name."_"."SYNTEX_H\n";
    print OUTPUT "#define   "."_".$f_name."_"."SYNTEX_H\n\n\n";

    while( <INPUT> )
    {
	if( /^\/(\w+)=(.*)/ )
	{
#chomp($1);
	    if( lc($1) eq "delimiters" )
	    {
		$define = "#define  ".uc($f_name."_".$1);
		$value	= "\"".$2."\"";
	    }
	    else
	    {

		$define = "#define  ".uc($f_name."_".$1);
		@argu = split(" ", $2);
		foreach( @argu )
		{
		    $_ = "\"".$_."\"";
		}
		$value = join ",", @argu;
	    }

	    print OUTPUT $define."\t".$value."\n";
	    
	}
	elsif( /^(.+)/ ){
	    if( /^\/(\w+)/ )
	    {
		if( lc($1) eq "keywords"){
		    $define = "#define  ".uc($f_name."_".$1);
		    print OUTPUT $define."\t";
		}
		elsif( lc($1) eq "keywords1"){
		    $define = "#define  ".uc($f_name."_".$1);
		    print OUTPUT $define."\t";
		}
		elsif( lc($1) eq "keywords2"){
		    $define = "#define  ".uc($f_name."_".$1);
		    print OUTPUT $define."\t";
		}
	    }
	    else
	    {
		@argu = split;
		foreach( @argu )
		{
		    $_ = "\"".$_."\"";
		}
		$value = join ",",@argu;
		print OUTPUT $value.",\\\n"
	    }
	}
    }
    print OUTPUT "\n\n#endif\n";
    close INPUT;
    close OUTPUT;
}
