/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/

#ifndef _PLTABLE_H
#define _PLTABLE_H

#include "general.h"
#include <stdio.h>




#define PL_LIST \
    Aml, Asm, Awk, C, Cobol, Csharp, Eiffel, Fortran, Make, Html, Java, Jscript, Lisp,\
    Lua, Pascal, Perl,Php, Python, Rexx, Ruby, Scheme, Tcl_tk, Shell, Verilog

typedef enum LangType{ Ignore=-1, PL_LIST }lang_type;

#define PL_LIST_STRING \
    "Aml", "Asm", "Awk", "C", "Cobol", "Csharp", "Eiffel", "Fortran", "Make",\
    "Html", "Java", "Jscript", "Lisp", "Lua", "Pascal", "Perl","Php",\
    "Python", "Rexx", "Ruby", "Scheme", "Tcl_tk", "Shell", "Verilog"
    
typedef enum Font_Type{
    Basic=0, Cmt, String, Keyword, Keyword1, Keyword2 ,
    Tag, Index
}font_type;

extern int font_type_num;

typedef struct Configure{
    char * bg_color;
    char * tag_bg_color;
    char * index_bg_color;


    char * tag_font_color;
    char * index_font_color;
    char * font_color;
    char * keyword_color;
    char * keyword1_color;
    char * keyword2_color;
    char * cmt_color;
    char * string_color;

    char * tag_font_size;
    char * index_font_size;
    char * font_size;
    char * keyword_size;
    char * keyword1_size;
    char * keyword2_size;
    char * cmt_size;
    char * string_size;

    char * tag_font_style;
    char * index_font_style;
    char * font_style;
    char * keyword_style;
    char * keyword1_style;
    char * keyword2_style;
    char * cmt_style;
    char * string_style;

    char * frameset;
    boolean is_dir_exist;
    boolean is_source_exist;
    boolean is_taglist_exist;

}configure;

extern configure conf;

typedef struct pl{
    const char	*   line_cmt;			/*one string*/
    const char	*   delimiters;			/*a number of chars*/
    const char  *   string_chars;		/*a number of chars*/
    const char	*   escape_char;		/*a number of chars*/
    const char	*   ignore_type;		/*a number of chars*/

    const char	* const*        keyword_block_on;/*a number of strings*/
    const char	* const*        keyword_block_off;/*a number of strings*/
    const char	* const*	file_extensions;/*a number of strings*/
    const char	* const*	keywords;	/*a number of strings*/
    const char	* const*	keywords1;	/*a number of strings*/
    const char	* const*	keywords2;	/*a number of strings*/
    const char	* const*        block_cmt_on;	/*a number of strings*/
    const char	* const*        block_cmt_off;	/*a number of strings*/

    const char	* const*	double_regexp_on;/*a number of strings*/
    const char	* const*	single_regexp_on;/*a number of strings*/
    const char	* const*	regexp_off;/*a number of strings*/

    /*deliminater ϱ  Ģ ϴ Լ*/
    int ( *exception_rule )(FILE *fin, char *token, int dlmt, FILE *fout);
    boolean dont_care;	/*,   */

    /*
       type ̸ ˱ ؼ type ׿  type ã  ε  type_name[i]
	 ؿ ˻Ѵ.
     */
    const char	*   type;
    const char	* const*	type_name;

    const char	*    element_type;
    const char	*    struct_type;
    const char	*   const*  element_divide_string;	
}PL;


extern const int pl_num;
extern PL pl_table[];

extern void init_pl_table(void);
extern void test_pl_table(void);
extern lang_type get_lang_type( const char *);
extern lang_type get_lang_type_with_extension( const char *);
extern void init_conf(void);
extern const char *get_type_name ( lang_type l, char type );
extern void release_element_kinds(void);


#endif
