/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "routines.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "makehtml.h"
#include "filelist.h"
#include "main.h"
#include "option.h"
#include "debug.h"
#include "taglist.h"
#include "diridx.h"

#include "htmlprocess.h"


char *tmp_html_dir;
char *html_dir;

char *html_name;
char *idx_name;
char *index_name;
char *taglist_name;

/*
   ޹ ϵ     丮 ̾
   װ html_dir ϰ, ɼǵ ű⿡   η
   ٽ ٲ۴.
   ⼭   丮 ؼ θ
   տ '/'  ʰ  ڿ '/'   ʴ 
   Ǿ ´. 
*/
void preprocess_options( char *argv[])
{
    char *dir;
    char *tmp;
    char buf[BUF_MAX];
    int len;
    fileStatus *stat;

    int i=0;
    html_dir	= NULL;
    /*
	html_dir	 
    */
    html_name = NULL;
    idx_name = "dir_index.html";
    taglist_name = "taglist.html";
    index_name = "index.html";

    argv[0] = "-N";
    for( i=1; argv[i] != NULL; i++ )
    {
	if( argv[i][0] == '-' ){
	    if ( strcmp( &argv[i][2], "help") == 0 ){
		print_help_msg();
		exit(0);
	    } else if( argv[i][1] == '-' && strncmp( &argv[i][2] , "target_dir=", 11 ) == 0 ){
		sprintf( buf,"%s/", &argv[i][13]);
		html_name = eStrdup(buf);
	    } else if( argv[i][1] == '-' && strncmp( &argv[i][2] , "dir_index_name=", 15 ) == 0 ){
		sprintf( buf,"%s", &argv[i][17] );
		idx_name = eStrdup(buf);
	    } else if( argv[i][1] ==  '-' && strncmp( &argv[i][2], "index_name=", 11 ) == 0 ){
		sprintf( buf,"%s", &argv[i][13] );
		index_name = eStrdup( buf );
	    } else if( argv[i][1] == '-' && strncmp( &argv[i][2] , "taglist_name=", 13 ) == 0 ){
		sprintf( buf,"%s", &argv[i][15] );
		taglist_name = eStrdup(buf);
	    }
	    else
		continue;
	}

	/*
	   丮ӿ ұϰ  /    ü Ͽ ڿ / δ.
	*/
	stat = eStat( argv[i] );
	len = strlen( argv[i] );
	if( stat->isDirectory &&  argv[i][len-1] != '/' ){
	    sprintf( buf,"%s/", argv[i] );
	    argv[i] = eStrdup(buf);
	}
	eStatFree(stat);

	dir = absoluteDirname( argv[i] );

	if( html_dir	== NULL ) 
	    html_dir	= dir; 
	else if( strcmp( html_dir, dir ) == 0 )
	    eFree( dir );
	else{
	    tmp	= html_dir;
	    html_dir = get_common_dir( html_dir, dir );
	    eFree(tmp);
	}

    }

    if( html_name == NULL ) 
	html_name = "HTML/";

    sprintf( buf,"%s%s", TMP_DIR, html_name );
    tmp_html_dir = eStrdup( buf );
    /*
        html_dir    ɼ  
    */
#ifdef DEBUG
    printf("htmldir : %s\n", html_dir );
#endif
    for( i=0; argv[i] != NULL; i++ )
    {
	if( argv[i][0] == '-' )
	    continue;

	/*̰  html_name ϸ
	   ϱ  none ɼ ü */
	if( isSameFile( argv[i] , html_name ))
	    argv[i] = "-N";
	else{
	    if( strcmp( argv[i], html_dir ) == 0 )
		argv[i] = "";
	    else
		argv[i] = relativeFilename(argv[i], html_dir);

	    if( argv[i][0] == '\0' )
		argv[i] = eStrdup( "./");
	}
    }
    return;
}


/*
   work_dir html_dir    θ  ִ.
    ۾ϰ ִ 丮 

   丮  ϸ
   html_dir = ó Էµ ϵ    
   CurrentDirectory = ɾ  丮
   TMP_DIR+html_name = /tmp 丮 ӽ÷ /html丮 
		Ŀ  丮 CurrentDirectory ̵
*/
static char *work_dir;

static void dir_process(file_entry *f)
{
    char    path[BUF_MAX];
    DIR	    *dir;	
    struct dirent   *file;
    file_entry	    *entry;
#if 0
    fputs("===========path=========", stderr);
    fputs( f->absolute_fname, stderr );
    fputs("  ", stderr);
#endif
    dir = opendir( f->absolute_fname );
    if( dir == NULL ) 
	error(FATAL, "open %s directory error %s %d \n", path ,
		__FILE__ , __LINE__);

    while( (file = readdir( dir )) != NULL )
    {
	if( file->d_name[0] == '.' ){
	    if( file->d_name[1] == '\0' )
		continue;
	    else if( file->d_name[1] == '.' && file->d_name[2] == '\0' )
		continue;
	}

	sprintf( path, "%s%s", f->relative_fname, file->d_name);
//	fputs( path, stderr);
//	fputs( "\n", stderr);
	entry = create_file_entry( eStrdup(path), 0 , f->is_R );	
	if( entry == NULL )
	    error( FATAL, "create file entry for %s error\n", file->d_name);
	if( entry != &binary_file )
	    insert_file_entry( entry );
    }
    closedir(dir);
}

static void frame_name_set(FILE *fd, const char *name)
{
    if( struppercmp( name , "dir" ) == 0 )
	fprintf(fd,"<frame name=\"dir\" src=\"%s\">\n" , idx_name);
    if( struppercmp( name , "source" ) == 0 )
	fprintf(fd,"<frame name=\"source\" src=\"\">\n");
    if( struppercmp( name , "taglist" ) == 0 )
	fprintf(fd,"<frame name=\"taglist\" src=\"%s\">\n", taglist_name);
}
static void frame_process()
{
    char buf[BUF_MAX];
    FILE *fd;
    char *token, *first, *second , *third;

    token = strtok( conf.frameset, (const char*)" ,");

    if( token == NULL )
	return;
    first = eStrdup(token);

    token = strtok( NULL, (const char*)" ,");
    if( token == NULL ){
	eFree( token );
	return;
    }
    second = eStrdup(token);

    token = strtok( NULL, (const char*)" ,");
    third = token;

    sprintf( buf, "%s%s", tmp_html_dir , index_name);
    fd = fopen( buf, "w");
    if( fd == NULL )
	error(FATAL, "open %s file error %s %d \n", buf,
		__FILE__ , __LINE__);
    fprintf(fd,"<html><head><title>Code2Html</title></head>\n" );
    if( third == NULL ){
	fprintf ( fd,"<frameset cols=\"20%c,80%c\">", '%','%' );
	frame_name_set(fd, first );
	frame_name_set(fd, second );
    }else {
	fprintf( fd, "<frameset cols=\"20%c,80%c\">",'%','%' );
	fprintf( fd, "<frameset rows=\"60%c,40%c\">",'%','%' );
	frame_name_set(fd, first );
	frame_name_set(fd, second );
	fprintf( fd,"</frameset>\n"); 
	frame_name_set(fd, third );
	eFree(third);
    }
    eFree( second);
    eFree( first);
    fprintf(fd,"</frameset></html>"); 
    fclose( fd);
}


/*
   ݵ d_name    ޴´. 
     '/'丮 ڴ  ʴ´.
 */
struct dirname_elmt{
    char *name;
    struct dirname_elmt *next;
};
static struct dirname_elmt *dirname_head=NULL;

static void push_dirname( char * dir_name )
{
    struct dirname_elmt *elmt;
    elmt = xMalloc( 1, struct dirname_elmt );
    elmt->name = dir_name;	
    elmt->next = dirname_head;
    dirname_head = elmt;
}
static char *pop_dirname()
{
    struct dirname_elmt *elmt;
    char *retval;
    if(dirname_head == NULL)
	return NULL;
    
    retval = dirname_head->name;

    elmt = dirname_head;
    dirname_head = elmt->next;

    eFree(elmt);

    return retval;
}

static void recursive_init_dir( const char *const d_name )
{
    char buf[BUF_MAX];
    char *dir_name;
    char *parent=NULL, *child = NULL;
    int i;

    dir_name = eStrdup( d_name );
    child = eStrdup(dir_name);
    for( i = strlen(dir_name) -2 ; i >= 0; i-- )
    {
	if( dir_name[i] == '/' )
	{
	    strncpy( buf, dir_name, i+1 );
	    buf[i+1] = '\0';
	    parent  = eStrdup(buf);
	    
	    /*
	        丮 ϸ ̻  丮 
	        ʿ䰡 .(ݵ  ϹǷ)  ݱ
	       Ƶ child丮  .
	        ߱  ó ° θ̴.
	     */
	    if( doesFileExist( child)){
		parent = pop_dirname();
		if( parent == NULL )
		    return;

		while( (child = pop_dirname()) != NULL ){
		    if( mkdir( parent , DIR_MODE )< 0 )
			error( FATAL, "create dir error %s :\n\t\t%s   %d ",
				parent , __FILE__, __LINE__);

		    eFree(parent);
		    parent = child;
		}
		if( mkdir( parent , DIR_MODE )< 0 ){
		    error( FATAL, "create dir error %s :\n\t\t%s   %d ",
			    parent , __FILE__, __LINE__);
		}
		
		eFree(parent);
		break;
	    }
	    else{
		push_dirname( child );
		child = parent;
	    }
	    
	}
    }
}

static void create_htmldir(const char *dir)
{
    char d_name[BUF_MAX];
    int len;

    len = sprintf( d_name, "%s%s%s", TMP_DIR, html_name, dir );

    if( !doesFileExist( d_name ) )
	recursive_init_dir(d_name);
}

/*
   html_name  ȣǾ Ѵ.
 */
extern void check_dir_exist()
{
    char buf[BUF_MAX];
    char cmd[BUF_MAX];
    int c;

    sprintf( buf, "%s%s", CurrentDirectory, html_name);
    if( doesFileExist(buf))
    {
	fprintf( stderr, "HTML dirctory is exist \n\
		this will overwrite HTML directory! continue?(y or n)");
	c = fgetc( stdin );
	if( c != 'y' ){
	    fprintf( stderr,"command stopped\n");
	    exit(0);
	}
	
	sprintf( cmd, "rm -Rf %s", buf );
	if( system( cmd) < 0 )
	    error(FATAL, "system function error %s", cmd);
    }	

    sprintf( buf, "%s%s", TMP_DIR, html_name);
    if( doesFileExist(buf))
    {
	sprintf( cmd, "rm -Rf %s", buf );
	if( system( cmd) < 0 )
	    error(FATAL, "system function error %s", cmd);
    }
}

void make_html(void)
{
    file_entry	*f;


    work_dir = " ";
    
    f = get_file_entry();
    if( f == NULL )
	return;

    create_htmldir(f->relative_dir);
    do{
	/*丮 Ǿ */
	if( strcmp( work_dir, f->relative_dir ) != 0 ){
	    work_dir = f->relative_dir;
	    create_htmldir(work_dir);
	}

	if( f->status->isDirectory ) {
	    
	    if( f->is_R || f->is_I )
		dir_process(f);
	}
	else
	{
	    if( f->language == Ignore )
		ignore_process(f);
	    else
		file_process(f);
	}
	free_file_entry( f);
    } while( (f = get_file_entry()) != NULL );
    
    switch( option.html_type ){
	case HtmlType:
	case CssType:
	    idx_process( tmp_html_dir );
	    break;
	case DhtmlType:
	    dhtml_idx_process( tmp_html_dir );
	    break;
    }
    frame_process(); 
}
