#!/usr/bin/perl -T
###################################################################################
#   this file is part of c2h
#   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###################################################################################/

@list = ("Aml", "Asm", "Awk", "C", "Cobol", "Csharp", "Eiffel", "Fortran", "Make",
    "Html", "Java", "Jscript", "Lisp", "Lua", "Pascal", "Perl", "Php",
    "Python", "Rexx", "Ruby", "Scheme", "Tcl_tk", "Shell", "Verilog");

open INPUT, "<list_kinds"
    or die  "file open error on list_kinds: $!";
open DEF_OUT,">def_list_kinds.h"
    or die  "file open error on def_list_kinds.h: $!";
open OUT,">list_kinds.h"
    or die  "file open error on list_kinds.h: $!";

@type = ();
@type_name = ();
$cont=0;
@element_type = ();
@struct_type = ();
while( <INPUT> )
{
    next unless /\S/;
    $line = $_;
    chomp( $line);
    if( /^\w+\s*/ ){	# ̸  
	    if( @type) {	  
		    if( $cont == 1 ){
		    print DEF_OUT "static char *".lc($name)."_type_name[]	=   {\"";
		    print DEF_OUT join "\",\"", @type_name;
		    print DEF_OUT "\"};\n";

		    print OUT	"pl_table[".ucfirst(lc($name))."].type   = \"";
		    print OUT	@type;
		    print OUT	"\";\n";

		    print OUT "pl_table[".ucfirst(lc($name))."].type_name =(const char* const*) ".lc($name)."_type_name;\n";

		    if( @element_type ne () ){
			print DEF_OUT "static char *".lc($name)."_element_divide_string[] = {";
			print DEF_OUT "\".\"";	
			if( lc($name) eq "c"){
			    print DEF_OUT ",\"->\"";	
			}
			print DEF_OUT "};\n";	

			print OUT "pl_table[".ucfirst(lc($name))."].element_type = \"";
			print OUT join "", @element_type;
			print OUT "\";\n";
			print OUT "pl_table[".ucfirst(lc($name))."].element_divide_string";
			print OUT " = (const char* const*)".lc($name)."_element_divide_string;\n";
		    }else{
			print OUT "pl_table[".ucfirst(lc($name))."].element_type = \'\\0\';\n";
			print OUT "pl_table[".ucfirst(lc($name))."].element_divide_string = (const char* const*)NULL;\n";
		    }
		    if( @struct_type ne () ){
			print OUT "pl_table[".ucfirst(lc($name))."].struct_type = \"";
			print OUT join "", @struct_type;
			print OUT "\";\n";
		    }else{
			print OUT "pl_table[".ucfirst(lc($name))."].struct_type = \'\\0\';\n";
		    }
		}
	    }
	    $name = $line;
	    @type = ();
	    @type_name = ();

	    $cont = 0;
	    @element_type = ();
	    @struct_type = ();
	    foreach( @list ){ 
		if( ucfirst(lc($line)) eq $_ ){	#ġҰ
		    $cont=1;
		}
	    }
	    if( lc("c#") eq lc($line) ){
		$cont=1;
		$name="Csharp";
	    }
	    if( lc("javascript") eq lc($line)){
		$cont=1;
		$name="Jscript";
	    }
	    if( lc("sh") eq lc($line)){
		$cont=1;
		$name="Shell";
	    }

    }
    elsif(@match = /^\s+\*(\w)\s+(.+)/){
	push @element_type , $match[0];
	push @type, $match[0];
	push @type_name, $match[1];
    }
    elsif(@match = /^\s+\^(\w)\s+(.+)/){
	push @struct_type , $match[0];
	push @type, $match[0];
	push @type_name, $match[1];
    }
    else{
	@match = /^\s+(\w)\s+(.+)/;
	push @type, $match[0];
	push @type_name, $match[1];
    }
}

close INPUT;
close OUT;
close DEF_OUT;
