/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
/*
   exception_rule и Ģ ߳ ͵ óҶ δ. 
   , и Ģ Ѱ  ϴµ, иڴ иڵ鳢, ڴ
   ڳ ū  δٴ ̴.
    иڿ ڰ  ̴ 쵵 ִµ, ׷  
   ̰ νϿ   ȴ.
     ruby =begin ִ.
   ̰쿡  =begin delimiters ν ϰ ؾ Ѵ. 
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "routines.h"
#include "htmlprocess.h"
#include "pltable.h"


/*
   fin string ִ ˻
 */
static boolean process(FILE *fin, char *token, const char *string)
{
    int i,c;
    int len;
    char *tmp;
    len = strlen( string );
    for( i = 0 ; i < len; i++ ){
	if( (c = fgetc(fin)) < 0 || string[i] != c ){
	    ungetc( c, fin);
	    break;
	}
    }
    if( i != len ){
	for(i--; i >=0 ; i-- ){
	    ungetc( string[i] , fin );
	}
	return FALSE;
    }
    else{
	tmp = eStrdup( token);
	sprintf( token , "%s%s", tmp, string );
	eFree( tmp );
	return TRUE;
    }
}

/*
   ҹ  
*/
static boolean upperProcess( FILE *fin, char *token, const char *string )
{
    int i,c,uc;
    int len;
    char *tmp;
    len = strlen( string );
    for( i = 0 ; i < len; i++ ){
	c = fgetc(fin);
	uc = ( toupper(c)) ? (~0x20 & c) : (c);
	if( c < 0 || string[i] != c ) {
	    if( string[i] == uc ){
		continue;
	    }
	    ungetc( c, fin);
	    break;
	}
    }
    if( i != len ){
	for(i--; i >=0 ; i-- ){
	    ungetc( string[i] , fin );
	}
	return FALSE;
    }
    else{
	tmp = eStrdup( token);
	sprintf( token , "%s%s", tmp, string );
	eFree( tmp );
	return TRUE;
    }
}
/*
   TODO
   s/ ,s#, m/ , m# , tr/, tr#
    token not delimitor ְ fin delimitor   ó
*/


/*
   TODO
   $_, token  delimater ְ fin not delinater ִ  ó
*/

/*
   TODO
     $/ , $@  delmitor ̷  Ű óؾϴ 
*/


/*
   s/ ,s#, m/ , m# , tr/, tr#
   $_, $/ , $@
*/
extern int perl_exception_rule( FILE *fin, char *token , int dlmt, FILE *fout)
{
    char *ptr;
    extern boolean in_regexp;
    
    if( strcmp( token , "s" ) == 0  || strcmp( token, "m" ) == 0 ||
	    strcmp( token, "tr" ) == 0)
    {
	if (process( fin, token, "/" ) || process(fin, token, "#"))
	    return 1;
    }

    if( in_regexp )
	return dlmt;

    if( strncmp( token, "$_" , 2 ) == 0 ||
	strncmp( token, "$/" , 2 ) == 0 ||
	strncmp( token, "$@" , 2 ) == 0 )
    {
	ungets( token+2, fin );
	token[2] = '\0';
	return 0;
    }else if( (ptr = strstr( token, "$_" )) != NULL ||
	      (ptr = strstr( token, "$/" )) != NULL ||
	      (ptr = strstr( token, "$@" )) != NULL )
    {
	ungets( ptr, fin );
	*ptr='\0';
	return 1;
    }
    return dlmt;
}

/*
   php  <?php ȿ dlmt_process ϵ ؾ Ѵ.  
    <?php  ?> ȿ dlmt ״ , 
   ׷  쿣 0 Ѵ.
TODO :
    line num  ó ؾѴ.
*/
#define PHP_EXCEPTION_RULE


extern int php_exception_rule( FILE *fin, char *token, int dlmt, FILE *fout )
{
    extern boolean in_line_cmt, in_block_cmt, in_string ;
    extern char begin_string_char;

    static boolean save_line_cmt = FALSE, save_string=FALSE, save_block_cmt=FALSE;
    static char save_begin_string_char = '\0';

    char *ptr;

    if( strcmp( token, "<?") == 0 ||
	strncmp( token, "?>",2 ) == 0 )
    {
	if( token[0] == '<' ){
	    if( upperProcess( fin, token, "php" )){
		if(  in_line_cmt || in_block_cmt || in_string )
		    font_end(fout);
		if( in_string ){
		    save_begin_string_char = begin_string_char;
		    begin_string_char = '\0';
		}
		
		
		
		save_line_cmt = in_line_cmt;
		save_string = in_string;
		save_block_cmt = in_block_cmt;
		in_line_cmt = FALSE;
		in_block_cmt = FALSE;
		in_string = FALSE;
		
	    }
	}else{
	    ungets( token+2, fin );
	    token[2] = '\0';

	    in_line_cmt = save_line_cmt;
	    in_block_cmt = save_block_cmt;
	    in_string = save_string;

	    if( in_line_cmt || in_block_cmt)
		font_begin( Cmt, conf.cmt_size, conf.cmt_color, conf.cmt_style, fout );
	    else if( in_string ){
		font_begin( String, conf.string_size, conf.string_color, conf.string_style, fout );
		begin_string_char = save_begin_string_char;
	    }
		
	}
    }
    else if( (ptr = strstr( token, "<?" )) != NULL ||
	     (ptr = strstr( token, "?>" )) != NULL )
    {
	if( *ptr == '<' ){
	    ungets( ptr, fin );
	    *ptr='\0';
	}else{
	    ungets( ptr, fin );
	    *ptr='\0';
	}

    }
    
    return dlmt;
}

#define RUBY_EXCEPTION_RULE
/*
   =begin  , =end
   $\' ó
*/
extern int ruby_exception_rule( FILE *fin, char *token, int dlmt , FILE *fout)
{
    int len;
    int c;
    char *ptr;
    extern boolean in_regexp;
    len = strlen( token );
    /* =begin	    =end ó*/
    if( token[len -1] == '=' ){
	if( len == 1 ){
	    if( (c = fgetc(fin)) < 0 ) return -1; 
	    ungetc( c, fin );
	    switch( c )
	    {
		case 'b':
		    if (process( fin, token, "begin" ))
			return 1;
		    break;

		case 'e':
		    if (process( fin, token, "end" ))
			return 1;
		    break;
	    }
	}
	else if( token[len-2] == '\n'){
	    token[len -1] = '\0';
	    ungetc( (int)'=', fin );
	}
    }else if( in_regexp )
	return dlmt;
    /* $\' ó */
    else {
	if( strncmp( token, "$\'" , 2 ) == 0 )
	{
	    ungets( token+2, fin );
	    token[2] = '\0';
	    return 0;
	}
	else if( (ptr = strstr( token, "$\'" )) != NULL )
	{
	    ungets( ptr, fin );
	    *ptr='\0';
	    return 1;
	}
    }
    return dlmt;

}
