/*
 3D draw test for frame buffer (Not use accelator)

 Code by JaeHyuk Cho <mailto:minzkn@infoeq.com>
*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include <linux/fb.h>

#include <math.h>

#define __DEF_3D_OPTIMIZE__ (1)

#if 0 /* Fast call */
#define __FC__ __attribute__((stdcall))
#else /* C call */
#define __FC__
#endif

#define __MZ_Alloc__(x) malloc((x))
#define __MZ_Free__(x)  free((x))

#define __MZ_PI__ (3.14159265358979323846)

struct ts_HandleFB
{  
 int *Break;
 int Handle;
 struct fb_fix_screeninfo fix;
 struct fb_var_screeninfo var;
 void *Map; /* Frame buffer memory */
 int MapSize;
 int bpp; /* Bytes per pixel */
};

struct ts_ObjectLine
{
 /* Linked list pointer */
 struct ts_ObjectLine *Next;
 /* Local crood */
 int Color;
 int x1, y1, z1;
 int x2, y2, z2;
 /* Rendering crood */
 int rx1, ry1, rx2, ry2;
};

static void __FC__ Sleeper(int s_mSleep);
static int __FC__ Do3D(struct ts_HandleFB *s_Handle);
static void Signal(int s_Signal);
static void __FC__ SetMemory(void *s_To, int s_Value, int s_Size);
static void __FC__ CopyMemory(void *s_To, const void *s_From, int s_Size);
static void __FC__ DrawPixel(struct ts_HandleFB *s_Handle, int s_Color, int s_x, int s_y);
static void __FC__ DrawLine(struct ts_HandleFB *s_Handle, int s_Color, int s_x1, int s_y1, int s_x2, int s_y2);
static struct ts_ObjectLine * __FC__ AddObjectLine(struct ts_ObjectLine *s_ObjectLine, int s_Color, int s_x1, int s_y1, int s_z1, int s_x2, int s_y2, int s_z2);
static struct ts_ObjectLine * __FC__ FreeObjectLine(struct ts_ObjectLine *s_ObjectLine);
static void __FC__ RotateObject(int *s_xx, int *s_yy, int *s_zz, double s_FrontRadian, double s_SideRadian, double s_TopRadian);
static void __FC__ RenderingObjectLine(struct ts_ObjectLine *s_ObjectLine, int s_Distance, int s_FrontAngle, int s_SideAngle, int s_TopAngle);
static void __FC__ DrawObjectLine(struct ts_HandleFB *s_Handle, struct ts_ObjectLine *s_ObjectLine, int s_Switch, int s_x, int s_y);
int main(int s_Argc, char *s_Argv[]);

static int __g_Break__ = 0;

static void __FC__ Sleeper(int s_mSleep)
{
 struct timeval s_TimeVal; 
 s_TimeVal.tv_sec = s_mSleep / 1000;
 s_TimeVal.tv_usec = (s_mSleep % 1000) * 1000;
 select(0, (fd_set *)0, (fd_set *)0, (fd_set *)0, (struct timeval *)(&s_TimeVal));
}

static int __FC__ Do3D(struct ts_HandleFB *s_Handle)
{
 int s_White, s_Distance, s_FrontAngle, s_SideAngle, s_TopAngle, s_Sleep;
 struct ts_ObjectLine *s_Object = (struct ts_ObjectLine *)0;

 s_White = 0xffffff;
 s_Distance = 400;
 s_FrontAngle = 0;
 s_SideAngle  = 0;
 s_TopAngle   = 0;

 s_Object = AddObjectLine(s_Object, s_White, -100, -100, +100, +100, -100, +100);
 s_Object = AddObjectLine(s_Object, s_White, +100, -100, +100, +100, +100, +100);
 s_Object = AddObjectLine(s_Object, s_White, +100, +100, +100, -100, +100, +100);
 s_Object = AddObjectLine(s_Object, s_White, -100, +100, +100, -100, -100, +100);
 
 s_Object = AddObjectLine(s_Object, s_White, -100, -100, -100, +100, -100, -100);
 s_Object = AddObjectLine(s_Object, s_White, +100, -100, -100, +100, +100, -100);
 s_Object = AddObjectLine(s_Object, s_White, +100, +100, -100, -100, +100, -100);
 s_Object = AddObjectLine(s_Object, s_White, -100, +100, -100, -100, -100, -100);
 
 s_Object = AddObjectLine(s_Object, s_White, -100, -100, +100, -100, -100, -100);
 s_Object = AddObjectLine(s_Object, s_White, +100, -100, +100, +100, -100, -100);
 s_Object = AddObjectLine(s_Object, s_White, +100, +100, +100, +100, +100, -100);
 s_Object = AddObjectLine(s_Object, s_White, -100, +100, +100, -100, +100, -100);

 s_Object = AddObjectLine(s_Object, s_White, -200, -200, +200, +200, -200, +200);
 s_Object = AddObjectLine(s_Object, s_White, +200, -200, +200, +200, +200, +200);
 s_Object = AddObjectLine(s_Object, s_White, +200, +200, +200, -200, +200, +200);
 s_Object = AddObjectLine(s_Object, s_White, -200, +200, +200, -200, -200, +200);
  
 s_Object = AddObjectLine(s_Object, s_White, -200, -200, -200, +200, -200, -200);
 s_Object = AddObjectLine(s_Object, s_White, +200, -200, -200, +200, +200, -200);
 s_Object = AddObjectLine(s_Object, s_White, +200, +200, -200, -200, +200, -200);
 s_Object = AddObjectLine(s_Object, s_White, -200, +200, -200, -200, -200, -200);
 
 s_Object = AddObjectLine(s_Object, s_White, -200, -200, +200, -200, -200, -200);
 s_Object = AddObjectLine(s_Object, s_White, +200, -200, +200, +200, -200, -200);
 s_Object = AddObjectLine(s_Object, s_White, +200, +200, +200, +200, +200, -200);
 s_Object = AddObjectLine(s_Object, s_White, -200, +200, +200, -200, +200, -200);

 /* For test KKOCKGGI */
 #if 0 
 s_Object = AddObjectLine(s_Object, s_White, -100, -100, +100, -110, -110, +100);
 #endif

 s_Sleep = 10 /* ms */;

 do
 {
  RenderingObjectLine(s_Object, s_Distance, s_FrontAngle, s_SideAngle, s_TopAngle);
  DrawObjectLine(s_Handle, s_Object, 1, s_Handle->var.xres >> 1, s_Handle->var.yres >> 1);
  Sleeper(s_Sleep);
  s_FrontAngle = (s_FrontAngle + 1) % 360;
  s_SideAngle  = (s_SideAngle + 1) % 360;
  s_TopAngle   = (s_TopAngle + 1) % 360;
  DrawObjectLine(s_Handle, s_Object, 0, s_Handle->var.xres >> 1, s_Handle->var.yres >> 1);
 }while(*s_Handle->Break == 0);

 s_Object = FreeObjectLine(s_Object);
 return(0);
}

static void Signal(int s_Signal)
{
 switch(s_Signal)
 {
  case SIGINT: __g_Break__ = 1; break;
  default: break;
 }
}

static void __FC__ SetMemory(void *s_To, int s_Value, int s_Size)
{
#ifdef WIN32
 (void)memset(s_To, s_Value, (size_t)s_Size);
#else
 __asm__ volatile(
  "\n\t"
  "movb %%al, %%ah\n\t"
  "movl %1, %%edx\n\t"
  "shll $16, %1\n\t"
  "movw %%dx, %%ax\n\t"
  "cld\n\t"
  "shrl $1, %2\n\t"
  "jnc 0f\n\t"
  "stosb %%al, %%es:(%0)\n\t"
  "0:\n\t"
  "shrl $1, %2\n\t"
  "jnc 0f\n\t"
  "stosw %%ax, %%es:(%0)\n\t"
  "0:\n\t"
  "repz stosl %1, %%es:(%0)\n\t"
  "\n\t"
  :
  : "D"(s_To), "a"(s_Value), "c"(s_Size)
 );
#endif
}

static void __FC__ CopyMemory(void *s_To, const void *s_From, int s_Size)
{
#if __DEF_3D_OPTIMIZE__ == (0)
 (void)memcpy(s_To, s_From, (size_t)s_Size);
#else
 __asm__ volatile(
  "\n\t"
  "cld\n\t"
  "shrl $1, %2\n\t"
  "jnc 0f\n\t"
  "movsb %%ds:(%1), %%es:(%0)\n\t"
  "0:\n\t"
  "shrl $1, %2\n\t"
  "jnc 0f\n\t"
  "movsw %%ds:(%1), %%es:(%0)\n\t"
  "0:\n\t"
  "repz movsl %%ds:(%1), %%es:(%0)\n\t"
  "\n\t"
  :
  : "D"(s_To), "S"(s_From), "c"(s_Size)
 );
#endif
}
static void __FC__ DrawPixel(struct ts_HandleFB *s_Handle, int s_Color, int s_x, int s_y)
{
 if(s_x >= 0 && s_y >= 0 && s_x < s_Handle->var.xres && s_y < s_Handle->var.yres)
 {
  CopyMemory(
   (void *)(((unsigned char *)s_Handle->Map) + (s_y * s_Handle->fix.line_length) + (s_x * s_Handle->bpp)), 
   (void *)(&s_Color), s_Handle->bpp);
 }
}

static void __FC__ DrawLine(struct ts_HandleFB *s_Handle, int s_Color, int s_x1, int s_y1, int s_x2, int s_y2)
{ 
 int s_GreatDelta, s_DeltaX, s_DeltaY, s_cx, s_cy, s_Index, s_StepX, s_StepY;
 s_DeltaX = s_x2 - s_x1, s_DeltaY = s_y2 - s_y1;
 if(s_DeltaX == 0 && s_DeltaY == 0)DrawPixel(s_Handle, s_Color, s_x1, s_y1);
 else
 {
  if(s_DeltaX >= 0)s_StepX = 1;
  else s_StepX = (-1), s_DeltaX = -s_DeltaX;
  if(s_DeltaY >= 0)s_StepY = 1;
  else s_StepY = (-1), s_DeltaY = -s_DeltaY;
  s_GreatDelta = s_DeltaX >= s_DeltaY ? s_DeltaX : s_DeltaY; 
  s_Index = s_cx = s_cy = 0;
  do
  {
   DrawPixel(s_Handle, s_Color, s_x1, s_y1);
   s_cx += s_DeltaX, s_cy += s_DeltaY;
   if(s_cx >= s_GreatDelta)s_cx -= s_GreatDelta, s_x1 += s_StepX;
   if(s_cy >= s_GreatDelta)s_cy -= s_GreatDelta, s_y1 += s_StepY;
  }while((s_Index++) < s_GreatDelta);
 }
}

static struct ts_ObjectLine * __FC__ AddObjectLine(struct ts_ObjectLine *s_ObjectLine, int s_Color, int s_x1, int s_y1, int s_z1, int s_x2, int s_y2, int s_z2)
{
 struct ts_ObjectLine *s_New;
 s_New = (struct ts_ObjectLine *)__MZ_Alloc__(sizeof(struct ts_ObjectLine));
 if(s_New)
 {
  s_New->Color = s_Color;
  s_New->x1 = s_x1, s_New->y1 = s_y1, s_New->z1 = s_z1;
  s_New->x2 = s_x2, s_New->y2 = s_y2, s_New->z2 = s_z2;
  
  s_New->rx1 = s_New->ry1 = s_New->rx2 = s_New->ry2 = 0;
  
  s_New->Next = s_ObjectLine;
  s_ObjectLine = s_New;
 }
 return(s_ObjectLine);
}

static struct ts_ObjectLine * __FC__ FreeObjectLine(struct ts_ObjectLine *s_ObjectLine)
{
 struct ts_ObjectLine *s_Trace;
 while(s_ObjectLine)
 { 
  s_Trace = s_ObjectLine;
  s_ObjectLine = s_ObjectLine->Next;
  __MZ_Free__((void *)s_Trace);
 }
 return(s_ObjectLine);
}

static void __FC__ RotateObject(int *s_xx, int *s_yy, int *s_zz, double s_FrontRadian, double s_SideRadian, double s_TopRadian)
{
 int s_x, s_y, s_z, s_sx, s_sy, s_sz;

 s_x = (*(s_xx));
 s_y = (*(s_yy));
 s_z = (*(s_zz));
 if(s_FrontRadian > 0) 
 {
  s_sx =  ((s_x * sin(s_FrontRadian)) - (s_y * cos(s_FrontRadian)));
  s_sy = -((s_x * cos(s_FrontRadian)) + (s_y * sin(s_FrontRadian)));
  s_x = s_sx, s_y = s_sy;  
 }
 if(s_SideRadian > 0)
 {
  s_sy =  ((s_y * sin(s_SideRadian)) - (s_z * cos(s_SideRadian))); 
  s_sz = -((s_y * cos(s_SideRadian)) + (s_z * sin(s_SideRadian)));
  s_y = s_sy, s_z = s_sz; 
 }
 if(s_TopRadian > 0)
 {
  s_sz =  ((s_z * sin(s_TopRadian)) - (s_x * cos(s_TopRadian))); 
  s_sx = -((s_z * cos(s_TopRadian)) + (s_x * sin(s_TopRadian)));
  s_z = s_sz, s_x = s_sx;
 }
 *(s_xx) = s_x;
 *(s_yy) = s_y;
 *(s_zz) = s_z;
}

static void __FC__ RenderingObjectLine(struct ts_ObjectLine *s_ObjectLine, int s_Distance, int s_FrontAngle, int s_SideAngle, int s_TopAngle)
{
 int s_x, s_y, s_z;
 double s_FrontRadian, s_SideRadian, s_TopRadian;
 s_FrontRadian = ((double)s_FrontAngle * ((double)2.0 * __MZ_PI__)) / (double)360.0;
 s_SideRadian  = ((double)s_SideAngle  * ((double)2.0 * __MZ_PI__)) / (double)360.0;
 s_TopRadian   = ((double)s_TopAngle   * ((double)2.0 * __MZ_PI__)) / (double)360.0;
 while(s_ObjectLine)
 {
  s_x = s_ObjectLine->x1;
  s_y = s_ObjectLine->y1;
  s_z = s_ObjectLine->z1;

  RotateObject(&s_x, &s_y, &s_z, s_FrontRadian, s_SideRadian, s_TopRadian);

  s_z -= s_Distance << 1;
  if(s_z == 0)s_z = 1;
  s_ObjectLine->rx1 = (s_Distance * s_x) / s_z;  
  s_ObjectLine->ry1 = (s_Distance * s_y) / s_z;  
 
  s_x = s_ObjectLine->x2;
  s_y = s_ObjectLine->y2;
  s_z = s_ObjectLine->z2;

  RotateObject(&s_x, &s_y, &s_z, s_FrontRadian, s_SideRadian, s_TopRadian);

  s_z -= s_Distance << 1;
  if(s_z == 0)s_z = 1;
  s_ObjectLine->rx2 = (s_Distance * s_x) / s_z;  
  s_ObjectLine->ry2 = (s_Distance * s_y) / s_z;  
 
  s_ObjectLine = s_ObjectLine->Next;
 }
}

static void __FC__ DrawObjectLine(struct ts_HandleFB *s_Handle, struct ts_ObjectLine *s_ObjectLine, int s_Switch, int s_x, int s_y)
{
 while(s_ObjectLine)
 {
  DrawLine(s_Handle, s_Switch == 0 ? 0 : s_ObjectLine->Color, 
           s_x + s_ObjectLine->rx1, s_y + s_ObjectLine->ry1, 
           s_x + s_ObjectLine->rx2, s_y + s_ObjectLine->ry2);
  s_ObjectLine = s_ObjectLine->Next;
 }
}

int main(int s_Argc, char *s_Argv[])
{
 struct ts_HandleFB s_Handle;
 char *s_FrameBufferDeviceName;
 
 fprintf(stdout, "3D box text for frame buffer.\n");
 fprintf(stdout, "Code by JaeHyuk Cho <mailto:minzkn@infoeq.com>\n");
 fprintf(stdout, "\n - Ctrl+C key to quit.\n");
 
 if(s_Argc > 1)s_FrameBufferDeviceName = s_Argv[1];
 else s_FrameBufferDeviceName = (char *)0;
 
 s_Handle.Handle = open( s_FrameBufferDeviceName ? s_FrameBufferDeviceName : "/dev/fb0", O_RDWR);
 if(s_Handle.Handle != 0)
 {
  if(ioctl(s_Handle.Handle, FBIOGET_FSCREENINFO, &s_Handle.fix) == 0 &&
     ioctl(s_Handle.Handle, FBIOGET_VSCREENINFO, &s_Handle.var) == 0)
  {
   size_t s_page_size;
   size_t s_alignment_miss_size;
   s_page_size = (size_t)(4 << 10);
   s_alignment_miss_size = ((size_t)s_Handle.fix.smem_start) % s_page_size;
   s_Handle.MapSize = (int)(s_Handle.fix.line_length * s_Handle.var.yres);
   if(s_alignment_miss_size != ((size_t)0))s_Handle.MapSize += s_page_size;
   s_Handle.Map = (void *)mmap((void *)s_Handle.fix.smem_start, 
                                 s_Handle.MapSize,
				 PROT_READ | PROT_WRITE, MAP_SHARED, s_Handle.Handle, 0);
   if(s_Handle.Map != (void *)(-1))
   {
    if(s_alignment_miss_size != ((size_t)0))
    {
     s_Handle.Map = ((unsigned char *)s_Handle.Map) + s_alignment_miss_size;
    }
    SetMemory(s_Handle.Map, 0, s_Handle.MapSize);
    s_Handle.bpp = s_Handle.var.bits_per_pixel >> 3;
    /* Install siganl */
    s_Handle.Break = (int *)(&__g_Break__);
    (void)signal(SIGINT, Signal);
    /* Ready ! fun ~ */
    (void)Do3D((struct ts_HandleFB *)(&s_Handle));
    /* Unmap */
    (void)munmap(s_Handle.Map, s_Handle.MapSize);
    fprintf(stdout, "Good bye.\n");
   }
   else fprintf(stdout, "Error: Can not mmap !\n");
  }
  else fprintf(stdout, "Error: Can not get fix & var info !\n");
  (void)close(s_Handle.Handle); 
 }
 else fprintf(stdout, "Error: Can not open fb device !\n");

 return(0);
}

/* End of source */
