///////////////////////////////////////
//	outliner.cs
//
//	  
//
///////////////////////////////////////
//	ڵ 
//
//	- : tactlee@yahoo.co.kr
//	- : 2003.10.08
//
//	- ȣ: 'VersionNo' ã 
//	- ȣ: 'BuildNo' ã 
//
////////////////////////////////////////
//	
//
//	resxgen /i:outliner.ico /o:outliner.resx /n:Icon
//		// ̰  .  bmp Ϸ ó .
//		// ̰  reseditor  ̿ؼ   .
//		////////////////////////////////
//	resgen OutlinerForm.resx OutlinerForm.resources
//	csc /win32icon:outliner.ico /res:OutlinerForm.resources /target:winexe outliner.cs
//
////////////////////////////////////////
//	 
//
//	- Ctrl + ¿ Ű Ѵ.
//	- ġ  .
//	- Redo/Undo  ִ´.
//	-   ͷ   ֵ Ѵ.
//	- MDI  ̿Ͽ     ֵ Ѵ.
//
////////////////////////////////////////
//	 
//
////////////////////////////////////////
//	ذ  
//
//	* 5: (2003.10.15)
//		- :  ؽƮ     ԷϷ  ؾ ϳ...
//			ؽƮ  '\n' ־Ƶ  ٿ µǾ.
//
//	* 11: (2003.11.16)   ߿
//		- : xml Ϸ   ѱ ڵ尡  Ǵµ html, txt Ϸ   UTF-8 ڵ Ǿ 
//			Ϲ ؽƮ ⿡   .
//
//	* 12: (2003.11.29) 
//		- : Assembly   α׷   VersionNo, BuildNo  ġų   ڴ.
//
//	* 17: (2003.12.15)
//		- :  ޴ HTML Ǵ TEXT   ҷ  , ο  ̸δ
//			 ȵǴ 찡 ־µ, Ȯ Ȳ  ľ ϰ ִ.
//
////////////////////////////////////////
//	ذ  
//
//	* 1: (2003.10.12) MyTreeView.ToggleExpandCollapse()
//		- : ޴󿡴 Collapse()  ص ڽ 忡  ġ ʴ´ٰ Ǿ ִµ
//			δ  ġ ִ.
//		- м: (2003.10.13) Microsoft TreeView Ŭ  װ ִٴ  Ȯߴ.
//			Ȯΰ Right Ű   ڽ  Ȯ  OnBeforeCollapse ̺Ʈ 
//			SelectedNode  ؼ   ߻ϴ ݸ, Collapse()  ؼ Ȯ  ڽ 
//			鼭  ڽ 鿡 Ͽ  , SelectedNode   ö鼭  , 
//			̷  ڽ 忡    OnBefoerCollapse ̺Ʈ ߻Ѵ.
//		- ذ: (2003.10.13) ӽ÷ OnBeforeCollapse() ؼ Collapse ̺Ʈ ߻ 
//			SelectedNode  ٸ    ʵ ߴ.
//
//	* 2: (2003.10.12) MoveSelectedNodeToUp(), MoveSelectedNodeToDown()
//		- : Clone() ؼ ̵ϸ ̵   ڽ  ҵǾ .
//		- м: (2003.10.14)   Clone() ǰ ׷   𸣰ڴ.
//		- ذ: (2003.10.14) CreateCloneNode()   Ȯ ¸ ߴ.
//
//	* 9: (2003.10.23)
//		- :   ġ ѱ Է ¿ Enter Ű ġ ѱ Է ° Ǿ Ŀ ̵ .
//		- ذ: (2003.10.24)  ġ ImeMode  ѱ Է ȵǵ Ͽ.
//			ImeMode  ִ ȿ  Է 带 ϰ ִ.  ѱ Է ¿ ImeMode  Ŀ
//			ٽ    ImeMode ؼ ѱ Է ° ȴ.
//
//	* 10: (2003.10.24)
//		- :    ޴  Ű   Է óϴ ߿  ߻Ѵ.
//		- м:   ¿  ޴  Ű ൿ Ư ؾ Ѵ.
//		- ذ: xxxMenuItemEnable.Set() ؼ ޴ ¸   ֵ Ͽ. 
//
//	* 8: (2003.10.22)
//		- :  ֱ  Thread    α׷ ؼ    ֵ Ǿ ִ.
//		- м: HelpThread() ϸ鼭  ȿ ޴  Ǿ .
//		- ذ:  IamHelpThreadFlag  ξ ڱ ڽ HelpThread  ν  ֵ Ͽ.
//
//	* 3: (2003.10.14) MyTreeView.ToggleExpandCollapse(), CollapseAll(), ExpandAll()
//		- : 1 ذϱ  ٺ ذå ƴϾ 带   ȭ ڰŸ.
//		- ذ: (2003.11.11)  Ȯ  Ŀ BeginUpdate() EndUpdate() Ͽ ذϿ.
//
//	* 6: (2003.10.14) MoveSelectedNodeToUp(), MoveSelectedNodeToDown()
//		- : 尡 ̵  ȭ ϰ ڰŸ.
//		- ذ: (2003.11.11)  Ȯ, , ̵ Ŀ BeginUpdate() EndUpdate() Ͽ ذϿ.
//
//	* 14: (2003.12.08)
//		- : ̹ ϴ Ͽ ⸦     ũⰡ    ũ⺸ ũٸ 
//			     Ⱑ ´.
//		- м: System.IO.File.OpenWrite()  ؼ  ̴. ̰       Ѵ.
//		- ذ: System.IO.File.OpenWrite()  ϱ    Ͽ.
//
//	* 13: (2003.12.08)
//		- : ٸ ̸   ȭ鿡 ǥõǴ  ̸  Ǵ  ̸ ٸ.
//		- м: XML   ϴ   . ׷ HTML ̳ ؽƮ    
//			̰  ۼ   ̸ ٲپ ȵȴ.
//		- ذ: 'ٸ ̸ ' ޴ XML ϸ ϰ, HTML  İ TEXT    
//			'' ޴ иϿ.
//
//	* 15: (2003.12.11)
//		- : StatusBar г ߰ϸ鼭  ũι Ϻΰ StatusBar г㿡   ʴ´.
//		- ذ: OutlinerForm.Controls.AddRange()  statusBar  treeView   ؼ ذߴ.
//
//	* 16: (2003.12.12)
//		- : üũڽ ̱⸦ ϰ  ϴ о üũڽ .
//		- ذ: BuildXmlDocument()  TopNode.Checked    ֵ ߴ.
//
//	* 7: (2003.10.16) LoadTree() 
//		- : xml  дٰ ϸ α׷  .
//		- ذ: (2003.12.17) LoadTree()  ȣϴ  try-catch  ־ ذϿ.
//
//	* 4: (2003.10.15)
//		- : Ϸ 带 ϸ鼭 ٴϸ  ũѹٴ ڵ ,  ũѹٴ Ÿ ʴ´.
//		- м: MyTreeView.Dock  DockStyle.Top     ũѹٰ Ÿ. ̰ 
//			DockStyle.Fill     ũѹٰ StatusBar    ʴ  Ǵܵȴ.
//		- ذ: (2003.12.17) OutlinerForm.Controls.AddRange()  statusBar, treeView   Ͽ ذϿ.
//
//	* 18: (2003.12.15)
//		- : üũڽ üũ/üũ   ȮҸ ϴ Space Ű 浹Ѵ.
//			  Ȯ        Ű ҴǾ Ѵ.
//		- ذ: (2003.12.17) MyTreeView.OnKeyPress()   ɿ  Ű 'm'   Ҵؼ ذϿ.
//
//  * 19: (2003.12.18)
//  	- :   Ctrl-C  ؼ Copy&Paste  Ϸ ϴµ   ȵȴ.
//  	- м: ޴ Ctrl-C  õ      ɿ  ״  浹 Ųϴ.
//
//	* 20: (2004.01.27)
//		- : ٰ   ۲ ũ⸦ ٲٸ ٲ ٰ ݿ ʴ´.
//		- м: ۲ ũ⸦ ϸ  ٰ ٽ ־ Ѵ.
//		- ذ: Option_SetFont()  ۲ ũ   ٰ  ϵ Ͽ.
//
//	* 21: (2004.01.30)
//		- : üũڽ ̱⸦  ȭ鿡 µ  Ȯ/ҿ  ģ.
//		- м: Ÿӿ TreeView.CheckBoxes Ӽ ϸ Ʈ  Ʈϵ TreeView ڵ ٽ 
//			(Control.RecreateHandle ).   õ TreeNode ϰ  Ʈ 尡 ҵǰ,
//			 Ʈ  TreeNode.Checked  .
//		- ذ: ڵ ٽ   Checked  IsExpanded  ߴٰ ٽ Ѵ.
//
//	* 22: (2003.02.02)
//		- : TopNode  TreeView  root node  ƴϰ, ȭ鿡  node  ù° node  ϴ ̴.
//			 TopNode  root node   ڵ ߴ κ  ɰ  ų  ִ.
//		- ذ: TopNode  root node  ǹϴ Nodes[0]  ٲپ.
//
//	* 23: (2004.02.04)
//		- :  ̱⸦ ϰ  ߱⸦ ϰ ؼ ٽ   Ⱥδ.
//		- м: root node    CheckBoxes    Checked   ʾƼ ߻ ̴.
//		- ذ:   CheckBoxes     Checked  ϵ ߰,   checked  ٸ
//			 Checked  false  ϵ ߴ.
//


///////////////////////////////////////////////////////////////////////////////
//	Using
//
using System;
using System.Collections;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Resources;
using System.Text;
using System.Threading;
using System.Xml;


///////////////////////////////////////////////////////////////////////////////
//	Assembly Info
//
using System.Reflection;
using System.Runtime.CompilerServices;

[assembly: AssemblyTitle("  ")]
[assembly: AssemblyDescription(" Top-Down İ Tree    ֵ ִ ")]
[assembly: AssemblyConfiguration("")]
[assembly: AssemblyCompany("mailto:tactlee@yahoo.co.kr, http://tactlee.pe.kr")]
[assembly: AssemblyProduct("  ")]
[assembly: AssemblyCopyright("GPL")]
[assembly: AssemblyTrademark("  ")]
[assembly: AssemblyCulture("")]		
[assembly: AssemblyVersion("1.2004.0204.7")]
[assembly: AssemblyDelaySign(false)]
[assembly: AssemblyKeyFile("")]
[assembly: AssemblyKeyName("")]


///////////////////////////////////////////////////////////////////////////////
//	class MainClass
//
class
MainClass {

	///////////////////////////////////
	//	Main()
	//
	static void 
	Main(
		string[]				args) {

		string					fileName;
		bool					readOnlyFlag;
		
		fileName		= (args.Length == 0) ? ""		: (args.Length == 1) ? args[0]	: args[1];
		readOnlyFlag	= (args.Length == 0) ? false	: (args.Length == 1) ? false	: true;

		Application.Run(new OutlinerForm(fileName, readOnlyFlag));
		}
	}
//
//	End of class MainClass
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
//	class OutlinerForm
//
class
OutlinerForm
: Form {

	string						VersionNo = "1.0 Beta";
	string						BuildNo = "20040204-7";
	string						ProgramName = "  ";

	string						currentFileName = null;
	bool						readOnlyFlag = false;

	MyTreeView					treeView;
	bool						IamHelpThreadFlag = false;

	static bool					HelpThreadFlag = false;

	StatusBar					statusBar;
	StatusBarPanel				statusBarPanel1;
	StatusBarPanel				statusBarPanel2;
	StatusBarPanel				statusBarPanelZ;

	ContextMenu					contextMenu;

	FontDialog					fontDialog;
	ColorDialog					colorDialog;

	///////////////////////////////////
	//	CurrentFileName
	//
	//	* : CurrentFileName.Set() CreateMainMenu()  踦  ִ.
	//		 CurrentFileName.Set() CreateMainMenu() ռ Ǿ ȵȴ.
	//
	string
	CurrentFileName {
		get { return currentFileName; }
		set {
			currentFileName = value;
			if( statusBarPanel1 != null ) {
				statusBarPanel1.Text = GetOnlyFileName(currentFileName);
				statusBarPanel1.ToolTipText = currentFileName;
				}
			Text = ProgramName;

			if( currentFileName == null ) {
				ViewMenuItemEnable = false;
				}
			else {
				Text += (IamHelpThreadFlag == true) ? " " : " - [" + statusBarPanel1.Text + "]";
				ViewMenuItemEnable = true;
				}
			ReconfigMenuItems();
			}
		}

	///////////////////////////////////
	//	GetOnlyFileName()
	//
	//	* :
	//		-  ̸  ̸    ̸ ش.
	string
	GetOnlyFileName(
		string					fullFileName) {

		string []				split = null;

		if( fullFileName != null ) {
			split = fullFileName.Split(new char [] { '\\' });
			return (split[split.Length - 1]);
			}
		return null;
		}

	///////////////////////////////////
	//	GetFileNameWithoutExtension()
	//
	//	* :
	//		-  ̸ Ȯڸ  ̸ ش.
	//
	string
	GetFileNameWithoutExtension(
		string					filename) {

		string []				split = null;
		string					new_filename = null;

		if( filename != null ) {
			split = filename.Split(new char [] { '.' });
			for(int i = 0; i < split.Length - 1; i++) {
				new_filename += split[i];
				}
			return new_filename;
			}
		return null;
		}

	///////////////////////////////////
	//	ReadOnlyFlag
	//
	bool
	ReadOnlyFlag {
		get { return readOnlyFlag; }
		set { readOnlyFlag = value;
			statusBarPanel2.Text = (readOnlyFlag == true) ? "б" : "";
			}
		}

	///////////////////////////////////
	//	OutlinerForm()
	//
	public
	OutlinerForm(
		string					fileName,
		bool					readOnlyFlag) {

		InitForm(readOnlyFlag);

		if( HelpThreadFlag == true) {
			IamHelpThreadFlag = true;
			}

		if( fileName != null && fileName != "" ) {
			CurrentFileName = fileName;
			try {
				treeView.LoadTree(fileName);
				SetStrikeOutChecked = treeView.flagUseStrikeOut;
				SetCheckBoxChecked = treeView.CheckBoxes;
				}
			catch( Exception ex ) {
				MessageBox.Show(ex.Message);
				CurrentFileName = null;
				}
			}
		else {
			CurrentFileName = null;
			}

		AllowDrop = true;
		DragDrop += new DragEventHandler(DragDropHandler);
		DragEnter += new DragEventHandler(DragEnterHandler);
		}

	///////////////////////////////////
	//	InitForm()
	//
	private
	void
	InitForm(
		bool					readOnlyFlag) {

		ResourceManager			resources;

		resources = new ResourceManager(typeof(OutlinerForm));
		Text = ProgramName;
		Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
        ClientSize = new Size(480, 320);
		// AutoScaleBaseSize = new Size(5, 13);

		CreateStatusBar();
		ReadOnlyFlag = readOnlyFlag;
			//	* : ReadOnlyFlag CreateStatusBar()  踦  ִ.
			////////
		CreateMainMenu();
			//	* : CurrentFileName.Set() CreateMainMenu()  踦  ִ.
			////////
		CreateContextMenu();
		CreateTreeView();

        //Controls.AddRange(new Control[] { statusBar, treeView });
        Controls.AddRange(new Control[] { treeView, statusBar });

		fontDialog = new FontDialog();
		fontDialog.Font = treeView.Font;
		fontDialog.Color = treeView.ForeColor;
		fontDialog.ShowColor = true;

		colorDialog = new ColorDialog();
		colorDialog.Color = treeView.BackColor;
		colorDialog.SolidColorOnly = true;
		}

	///////////////////////////////////
	//	DragEnterHandler()
	//
	private 
	void
	DragEnterHandler(
		object					sender, 
		DragEventArgs 			e) {

		if (e.Data.GetDataPresent(DataFormats.FileDrop) ) {
			e.Effect = DragDropEffects.Copy;
   			}
		}	

	///////////////////////////////////
	//	DragDropHandler()
	//
	private 
	void
	DragDropHandler(
		object					sender, 
		DragEventArgs 			e) {

		if(e.Data.GetDataPresent(DataFormats.FileDrop) ) {
			string[]			files;

			files = (string[])e.Data.GetData(DataFormats.FileDrop);
			try {
				treeView.LoadTree(files[0]);
				SetStrikeOutChecked = treeView.flagUseStrikeOut;
				SetCheckBoxChecked = treeView.CheckBoxes;
				ReadOnlyFlag = false;
				CurrentFileName = files[0];
				}
			catch(Exception ex) {
				MessageBox.Show(ex.Message);
				return;
				}
			}
		}	

	//*****************************************************
	//
	//	Main Menu
	//
	//*****************************************************

	///////////////////////////////////
	//	CreateMainMenu()
	//
	//	* :
	//		-  ޴ Ѵ.
	//	* :
	//		- ޴ ġ Ǹ ݵ xxxMenuItemsEnable.Set() ϰ ִ ش ޴ ε 
	//			 ־ Ѵ.
	//
	void
	CreateMainMenu() {

		Menu = new MainMenu();

		Menu.MenuItems.Add("(&F)", new MenuItem[] {
			new MenuItem(" (&N)", new EventHandler(this.File_New), Shortcut.CtrlN),
			new MenuItem("(&O)", new EventHandler(this.File_Open), Shortcut.CtrlO),
			new MenuItem("б  (&R)", new EventHandler(this.File_OpenForReadOnly), Shortcut.CtrlR),
			new MenuItem("-"),
			new MenuItem("(&S)", new EventHandler(this.File_Save), Shortcut.CtrlS),
			new MenuItem("ٸ ̸ (&A)", new EventHandler(this.File_SaveAs), Shortcut.F12),
			new MenuItem("(&E)", new MenuItem[] {
				new MenuItem("HTML  ", new EventHandler(this.File_ExportAsHtml)),
				new MenuItem("ؽƮ  ", new EventHandler(this.File_ExportAsText)),
				}),
			new MenuItem("-"),
			new MenuItem("(&X)", new EventHandler(this.File_Exit)),
			});
		Menu.MenuItems.Add("(&E)", new MenuItem[] {
			new MenuItem(" (&E)", new EventHandler(this.Edit_EditNode)),
			new MenuItem("-"),
			new MenuItem("   ", new EventHandler(this.Edit_NewSiblingNodeInFrontOfSelectedNode)),
			new MenuItem("Ʒ   ", new EventHandler(this.Edit_NewSiblingNodeInBackOfSelectedNode)),
			new MenuItem(" ؿ   ߰", new EventHandler(this.Edit_NewChildNode)),
			new MenuItem("-"),
			new MenuItem(" (&D)", new EventHandler(this.Edit_RemoveNode), Shortcut.CtrlD),
			new MenuItem("-"),
			new MenuItem(" ̵(&K)", new EventHandler(this.Edit_MoveNodeToUp), Shortcut.CtrlK),
			new MenuItem("Ʒ ̵(&J)", new EventHandler(this.Edit_MoveNodeToDown), Shortcut.CtrlJ),
			new MenuItem("  ̵(&H)", new EventHandler(this.Edit_MoveNodeToParent), Shortcut.CtrlH),
			new MenuItem("  ̵(&L)", new EventHandler(this.Edit_MoveNodeToChild), Shortcut.CtrlL),
			});
		Menu.MenuItems.Add("(&V)", new MenuItem[] {
			new MenuItem("   (&C)", new EventHandler(this.View_CollapseAll)),
			new MenuItem("   Ȯ(&E)", new EventHandler(this.View_ExpandAll)),
			new MenuItem("-"),
			new MenuItem("üũڽ ̱(&X)", new EventHandler(this.View_CheckBoxes)),
			new MenuItem(" ̱(&X)", new EventHandler(this.View_StrikeOut)),
			});
		Menu.MenuItems.Add("(&O)", new MenuItem[] {
			new MenuItem("۲ (&F)", new EventHandler(this.Option_SetFont)),
			new MenuItem(" (&B)", new EventHandler(this.Option_SetBackColor)),
			new MenuItem("ٰ (&L)", new EventHandler(this.Option_SetLineHeight)),
			});
		Menu.MenuItems.Add("(&H)", new MenuItem[] {
			new MenuItem("   ", new EventHandler(this.Help_Usage), Shortcut.F1),
			new MenuItem("   ", new EventHandler(this.Help_About), Shortcut.F11),
			});
		SetCheckBoxChecked = false;
		}

	bool FileNewMenuItemEnable		{ set { Menu.MenuItems[0].MenuItems[0].Enabled = value; }	}
	bool FileOpenMenuItemEnable		{ set { Menu.MenuItems[0].MenuItems[1].Enabled = value; }	}
	bool FileSaveMenuItemEnable		{ set { Menu.MenuItems[0].MenuItems[4].Enabled = value; }	}
	bool FileSaveAsMenuItemEnable	{ set { Menu.MenuItems[0].MenuItems[5].Enabled = value; }	}
	bool FileExportAsMenuItemEnable	{ set { Menu.MenuItems[0].MenuItems[6].Enabled = value; }	}
	bool EditMenuItemEnable			{ set { Menu.MenuItems[1].Enabled = value; }				}
	bool ViewMenuItemEnable			{ set { Menu.MenuItems[2].Enabled = value; }				}
	bool HelpUsageMenuItemEnable	{ set { Menu.MenuItems[4].MenuItems[0].Enabled = value; }	}

	bool GetCheckBoxChecked			{ get { return Menu.MenuItems[2].MenuItems[3].Checked; }	}
	bool SetCheckBoxChecked			{ set { 
										Menu.MenuItems[2].MenuItems[3].Checked = value; 
										if( treeView != null ) { 
											treeView.SetCheckBoxes(value);
											}
										}														}
	bool GetStrikeOutChecked		{ get { return Menu.MenuItems[2].MenuItems[4].Checked; }	}
	bool SetStrikeOutChecked		{ set { 
										Menu.MenuItems[2].MenuItems[4].Checked = value;
										if( treeView != null ) { 
											treeView.SetStrikeOutFont(value);
											}
										}														}

	void
	EnableEditRelatedMenuItems() {
		FileSaveMenuItemEnable =
		FileSaveAsMenuItemEnable =
		FileExportAsMenuItemEnable =
		EditMenuItemEnable = true;
		}

	void
	DisableEditRelatedMenuItems() {
		FileSaveMenuItemEnable =
		FileSaveAsMenuItemEnable =
		FileExportAsMenuItemEnable =
		EditMenuItemEnable = false;
		}

	void
	DisableHelpRelatedMenuItems() {
		FileNewMenuItemEnable =
		FileOpenMenuItemEnable =
		FileSaveMenuItemEnable =
		FileSaveAsMenuItemEnable =
		FileExportAsMenuItemEnable =
		EditMenuItemEnable =
		HelpUsageMenuItemEnable = false;
		}

	///////////////////////////////////
	//	CreateContextMenu()
	//
	//	* :
	//		- 콺  ư   ȭ鿡  ޴  Ѵ.
	//
	void
	CreateContextMenu() {
		contextMenu = new ContextMenu();
		contextMenu.MenuItems.Add(" (&E)", new EventHandler(Edit_EditNode));
		contextMenu.MenuItems.Add("-");
		contextMenu.MenuItems.Add("   (&I)", new EventHandler(Edit_NewSiblingNodeInFrontOfSelectedNode));
		contextMenu.MenuItems.Add("Ʒ   (&O)", new EventHandler(Edit_NewSiblingNodeInBackOfSelectedNode));
		contextMenu.MenuItems.Add(" ؿ   ߰(&A)", new EventHandler(Edit_NewChildNode));
		contextMenu.MenuItems.Add("-");
		contextMenu.MenuItems.Add(" (&D)", new EventHandler(Edit_RemoveNode));
		contextMenu.MenuItems.Add("-");
		contextMenu.MenuItems.Add(" ̵(&K)", new EventHandler(Edit_MoveNodeToUp));
		contextMenu.MenuItems.Add("Ʒ ̵(&J)", new EventHandler(Edit_MoveNodeToDown));
		contextMenu.MenuItems.Add("  ̵(&H)", new EventHandler(Edit_MoveNodeToParent));
		contextMenu.MenuItems.Add("  ̵(&L)", new EventHandler(Edit_MoveNodeToChild));
		contextMenu.MenuItems.Add("-");
		contextMenu.MenuItems.Add("   (&C)", new EventHandler(this.View_CollapseAll));
		contextMenu.MenuItems.Add("   Ȯ(&E)", new EventHandler(this.View_ExpandAll));
		}

	///////////////////////////////////
	//	ReconfigMenuItems()
	//
	//	* :
	//		- α׷ ¿  MenuItems  Enable ¸ 缳Ѵ.
	//	* :
	//		- ޴ ġ Ǹ ݵ xxxMenuItemsEnable.Set() ϰ ִ ش ޴ ε 
	//			 ־ Ѵ.
	//
	void
	ReconfigMenuItems() {
		
		if( CurrentFileName != null ) {
			if( IamHelpThreadFlag == true ) {
				DisableHelpRelatedMenuItems();
				}
			else if( ReadOnlyFlag == true ){
				DisableEditRelatedMenuItems();
				}
			else {
				EnableEditRelatedMenuItems();
				}
			}
		else {
			DisableEditRelatedMenuItems();
			}
		}


	//*****************************************************
	//
	//	File Menu Event Handlers
	//
	//*****************************************************

	///////////////////////////////////
	//	File_New()
	//
	void
	File_New(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName == null
		||	treeView.ChangedFlag == false
		||	ShowDialogToCheckDirty() != DialogResult.Cancel ) {

			CurrentFileName = "noname.xml";
			treeView.ClearAllWithFileName(CurrentFileName);
			treeView.CheckBoxes = GetCheckBoxChecked;
			ReadOnlyFlag = false;
			treeView.Nodes[0].BeginEdit();
			}
		}

	///////////////////////////////////
	//	ShowDialogToCheckDirty()
	//
	DialogResult
	ShowDialogToCheckDirty() {		
		string					message = "ۼϴ  Ǿϴ.\n\nϽðڽϱ?";
		string					caption = " ";
		DialogResult			result;

		result = MessageBox.Show(message, caption, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Warning);
		if( result == DialogResult.Yes ) {
			treeView.SaveTree();
			}
		return result;
		}

	///////////////////////////////////
	//	File_Open()
	//
	void
	File_Open(
		object					sender, 
		EventArgs				e) {

		FileOpenDialog(false);
		}

	///////////////////////////////////
	//	File_OpenForReadOnly()
	//
	void
	File_OpenForReadOnly(
		object					sender, 
		EventArgs				e) {

		FileOpenDialog(true);
		}

	void
	FileOpenDialog(
		bool					openForReadOnlyFlag) {

		if( CurrentFileName == null
		||	treeView.ChangedFlag == false
		||	ShowDialogToCheckDirty() != DialogResult.Cancel ) {

			OpenFileDialog			openFileDialog = new OpenFileDialog();

			openFileDialog.Filter = "XML Files (*.xml) |*.xml";
			if( openFileDialog.ShowDialog() == DialogResult.OK ) {
				try {
					treeView.LoadTree(openFileDialog.FileName);
					SetStrikeOutChecked = treeView.flagUseStrikeOut;
					SetCheckBoxChecked = treeView.CheckBoxes;
					ReadOnlyFlag = openForReadOnlyFlag;
					CurrentFileName = openFileDialog.FileName;
					}
				catch( Exception ex ) {
					MessageBox.Show(ex.Message);
					return;
					}
				}
			}
		}

	///////////////////////////////////
	//	File_Save()
	//
	void
	File_Save(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.SaveTree();
			}
		}

	///////////////////////////////////
	//	File_SaveAs()
	//
	void
	File_SaveAs(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			SaveFileDialog		saveFileDialog;

			saveFileDialog = new SaveFileDialog();
			saveFileDialog.FileName = treeView.FileName;
			saveFileDialog.Filter = "XML  (*.xml)|*.xml";
			if( saveFileDialog.ShowDialog() == DialogResult.OK ) {
				treeView.SaveTreeAsXml(saveFileDialog.FileName);
				CurrentFileName = saveFileDialog.FileName;
				}
			}
		}

	///////////////////////////////////
	//	File_ExportAsHtml()
	//
	void
	File_ExportAsHtml(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			SaveFileDialog		saveFileDialog;

			saveFileDialog = new SaveFileDialog();
			saveFileDialog.Title = "HTML   ";
			saveFileDialog.FileName = GetFileNameWithoutExtension(treeView.FileName);
			saveFileDialog.Filter = "HTML  (*.html)|*.html";
			if( saveFileDialog.ShowDialog() == DialogResult.OK ) {
				treeView.ExportAsHtml(saveFileDialog.FileName);
				}
			}
		}

	///////////////////////////////////
	//	File_ExportAsText()
	//
	void
	File_ExportAsText(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			SaveFileDialog		saveFileDialog;

			saveFileDialog = new SaveFileDialog();
			saveFileDialog.Title = "Text   ";
			saveFileDialog.FileName = GetFileNameWithoutExtension(treeView.FileName);
			saveFileDialog.Filter = "ؽƮ  (*.txt)|*.txt";
			if( saveFileDialog.ShowDialog() == DialogResult.OK ) {
				treeView.ExportAsText(saveFileDialog.FileName);
				}
			}
		}

	///////////////////////////////////
	//	File_Exit()
	//
	void
	File_Exit(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName == null
		||	treeView.ChangedFlag == false
		||	ShowDialogToCheckDirty() != DialogResult.Cancel ) {

			this.Close();
			}
		}

	
	//*****************************************************
	//
	//	Edit Menu Event Handlers
	//
	//*****************************************************

	///////////////////////////////////
	//	Edit_NewChildNode()
	//
	void
	Edit_NewChildNode(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.AppendToSelectedNode();
			}
		}

	///////////////////////////////////
	//	Edit_NewSiblingNodeInFrontOfSelectedNode()
	//
	void
	Edit_NewSiblingNodeInFrontOfSelectedNode(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.InsertInFrontOfSelectedNode();
			}
		}

	///////////////////////////////////
	//	Edit_NewSiblingNodeInBackOfSelectedNode()
	//
	void
	Edit_NewSiblingNodeInBackOfSelectedNode(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.InsertInBackOfSelectedNode();
			}
		}

	///////////////////////////////////
	//	Edit_EditNode()
	//
	void
	Edit_EditNode(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.EditSelectedNode();
			}
		}

	///////////////////////////////////
	//	Edit_RemoveNode()
	//
	void
	Edit_RemoveNode(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			if( treeView.SelectedNode != treeView.Nodes[0] ) {
				treeView.Nodes.Remove(treeView.SelectedNode);
				}
			}
		}

	///////////////////////////////////
	//	Edit_MoveNodeToUp()
	//
	void
	Edit_MoveNodeToUp(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.MoveSelectedNodeToUp();
			}
		}

	///////////////////////////////////
	//	Edit_MoveNodeToDown()
	//
	void
	Edit_MoveNodeToDown(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.MoveSelectedNodeToDown();
			}
		}

	///////////////////////////////////
	//	Edit_MoveNodeToParent()
	//
	void
	Edit_MoveNodeToParent(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.MoveSelectedNodeToParent();
			}
		}

	///////////////////////////////////
	//	Edit_MoveNodeToChild()
	//
	void
	Edit_MoveNodeToChild(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.MoveSelectedNodeToChild();
			}
		}

	//*****************************************************
	//
	//	View Menu Event Handlers
	//
	//*****************************************************

	///////////////////////////////////
	//	View_CollapseAll()
	//
	void
	View_CollapseAll(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.CollapseAllSelectedNode();
			}
		}

	///////////////////////////////////
	//	View_ExpandAll()
	//
	void 
	View_ExpandAll(
		object					sender, 
		EventArgs				e) {

		if( CurrentFileName != null ) {
			treeView.ExpandAllSelectedNode();
			}
		}

	///////////////////////////////////
	//	View_CheckBoxes()
	//
	void 
	View_CheckBoxes(
		object					sender, 
		EventArgs				e) {

		if( GetCheckBoxChecked == true ) {
			SetCheckBoxChecked = false;
			}
		else {
			SetCheckBoxChecked = true;
			}
		}

	///////////////////////////////////
	//	View_StrikeOut()
	//
	void 
	View_StrikeOut(
		object					sender, 
		EventArgs				e) {

		if( GetStrikeOutChecked == true ) {
			SetStrikeOutChecked = false;
			}
		else {
			SetStrikeOutChecked = true;
			}
		}

	//*****************************************************
	//
	//	Option Menu Event Handlers
	//
	//*****************************************************

	///////////////////////////////////
	//	Option_SetFont()
	//
	void
	Option_SetFont(
		object					sender, 
		EventArgs				e) {

		if( fontDialog.ShowDialog() != DialogResult.Cancel ) {
			treeView.Font = fontDialog.Font;
			treeView.StrikeOutFont = new Font(treeView.Font, treeView.Font.Style | FontStyle.Strikeout);
			treeView.ForeColor = fontDialog.Color;
			treeView.LineHeight = treeView.LineHeight;	// ٰ 
			}
		}

	///////////////////////////////////
	//	Option_SetBackColor()
	//
	void
	Option_SetBackColor(
		object					sender, 
		EventArgs				e) {

		if( colorDialog.ShowDialog() != DialogResult.Cancel ) {
			treeView.BackColor = colorDialog.Color;
			}
		}

	///////////////////////////////////
	//	Option_SetLineHeight()
	//
	void
	Option_SetLineHeight(
		object					sender, 
		EventArgs				e) {

		Form dialog = new Form();
			dialog.Text = "ٰ ";
			dialog.Width = 200;
			dialog.Height = 130;
			dialog.StartPosition = FormStartPosition.CenterParent;

		Label label = new Label();
			label.Text = "ٰ:";
			label.Size = new Size(50, 20);
			label.Location = new Point(20, 23);

		TextBox	textBox = new TextBox();
			textBox.Text = treeView.LineHeight.ToString();
			textBox.Size = new Size(50, 20);
			textBox.Location = new Point(label.Right, label.Top - 3);

		Label label2 = new Label();
			label2.Text = "%";
			label2.Size = new Size(20, 20);
			label2.Location = new Point(textBox.Right, label.Top);

		Button buttonOk = new Button();
			buttonOk.Text = "Ȯ";
			buttonOk.DialogResult = DialogResult.OK;
			buttonOk.Size = new Size(75, 25);
			buttonOk.Location = new Point(20, dialog.Height - 70);

		Button buttonCancel = new Button();
			buttonCancel.Text = "";
			buttonCancel.DialogResult = DialogResult.Cancel;
			buttonCancel.Size = new Size(75, 25);
			buttonCancel.Location = new Point(buttonOk.Right + 10, buttonOk.Top);

		dialog.AcceptButton = buttonOk;
		dialog.CancelButton = buttonCancel;
		dialog.Controls.Add(label);
		dialog.Controls.Add(textBox);
		dialog.Controls.Add(label2);
		dialog.Controls.Add(buttonOk);
		dialog.Controls.Add(buttonCancel);

		int dialogLineHeight;
		do {
			dialog.ShowDialog();
			if( dialog.DialogResult == DialogResult.Cancel ) {
				break;
				}
			dialogLineHeight = Convert.ToInt32(textBox.Text);
			if( 300 >= dialogLineHeight && dialogLineHeight >= 100 ) {
				break;
				}
			MessageBox.Show(
				"ٰ ּ 100, ִ 300     ֽϴ.", " Է ", 
				MessageBoxButtons.OK, MessageBoxIcon.Warning
				);
			} while(true);

		if( dialog.DialogResult == DialogResult.OK ) {
			treeView.LineHeight = Convert.ToInt32(textBox.Text);
			}
		}

	//*****************************************************
	//
	//	Help Menu Event Handlers
	//
	//*****************************************************

	///////////////////////////////////
	//	Help_Usage()
	//
	void
	Help_Usage(
		object					sender, 
		EventArgs				e) {

		if(	HelpThreadFlag == false ) {
			Thread				newThread;

			HelpThreadFlag = true;
			HelpUsageMenuItemEnable = false;

			newThread = new Thread(new ThreadStart(HelpThread));
			newThread.Name = "Help Thread";
			newThread.Start();
			}
		}

	///////////////////////////////////
	//	HelpThread()
	//
	void
	HelpThread() {
		Application.Run(new OutlinerForm("c:\\program files\\outliner\\help.xml", true));

		HelpUsageMenuItemEnable = true;
		HelpThreadFlag = false;
		}

	///////////////////////////////////
	//	Help_About()
	//
	void
	Help_About(
		object					sender, 
		EventArgs				e) {

		MessageBox.Show(
			"  \n"
			+ "Version " + VersionNo + " Build " + BuildNo + "  \n\n"
			+ "mailto: tactlee@yahoo.co.kr     \n"
			+ "http://tactlee.pe.kr\n\n"
			, "   ",
			MessageBoxButtons.OK, 
			MessageBoxIcon.Information
			);
		}

	///////////////////////////////////
	//	CreateTreeView()
	//
	void
	CreateTreeView() {

		treeView = new MyTreeView(
			ref statusBarPanel1, ref statusBarPanelZ, 
			ref contextMenu, ref VersionNo, ref BuildNo, ref ProgramName
			);

		treeView.Dock = DockStyle.Fill;
		treeView.Scrollable = true;
		treeView.Enabled = true;
		treeView.BackColor = Color.Yellow;
		treeView.LabelEdit = true;
		treeView.ShowRootLines = true;
		treeView.HotTracking = true;
		treeView.ShowLines = true;			// ShowLines == true ̸ FullRowSelect Ӽ õȴ.
		// treeView.FullRowSelect = true;

		treeView.BeginUpdate();
		treeView.Nodes.Clear();
		treeView.EndUpdate();

		Controls.Add(treeView);
		}

	///////////////////////////////////
	//	CreateStatusBar()
	//
	void
	CreateStatusBar() {

		statusBarPanel1 = new StatusBarPanel();
			statusBarPanel1.BorderStyle = StatusBarPanelBorderStyle.Sunken;
			if( CurrentFileName != null ) {
				statusBarPanel1.Text = GetOnlyFileName(CurrentFileName);
				statusBarPanel1.ToolTipText = CurrentFileName;
				}
			statusBarPanel1.AutoSize = StatusBarPanelAutoSize.Contents;

		statusBarPanel2 = new StatusBarPanel();
			statusBarPanel2.BorderStyle = StatusBarPanelBorderStyle.Sunken;
			statusBarPanel2.AutoSize = StatusBarPanelAutoSize.Contents;

		statusBarPanelZ = new StatusBarPanel();
			statusBarPanelZ.BorderStyle = StatusBarPanelBorderStyle.Sunken;
			statusBarPanelZ.ToolTipText = System.DateTime.Now.ToShortTimeString();
			statusBarPanelZ.Text = System.DateTime.Today.ToLongDateString();
			statusBarPanelZ.AutoSize = StatusBarPanelAutoSize.Contents;

		statusBar = new StatusBar();
			statusBar.Panels.Add(statusBarPanel1);
			statusBar.Panels.Add(statusBarPanel2);
			statusBar.Panels.Add(statusBarPanelZ);
			statusBar.ShowPanels = true;

		Controls.Add(statusBar);
		}
	}
//
//	End of class OutlinerForm
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//	class MyTreeView
//
class
MyTreeView
: TreeView {

	string						versionNo;
	string						buildNo;
	string						programName;

	bool						changedFlag = true;
	bool						ToggleExpandCollapseFlag = false;
	string						fileName = null;
	Point						xyMouseDown = new Point();
	int							lineHeight = 100;

	public Font					StrikeOutFont;
	public bool					flagUseStrikeOut = false;

	private	bool				DeleteLineFlag = false;
	private	bool				CollapseAllFlag = false;
	private	bool				ExpandAllFlag = false;

	private Queue				queueChecked = new Queue();
	private Queue				queueIsExpanded = new Queue();

	ContextMenu					contextMenu;
	StatusBarPanel				statusBarPanel1;
	StatusBarPanel				statusBarPanelZ;

	///////////////////////////////////
	//	ChangedFlag
	//
	public
	bool
	ChangedFlag {
		get { return changedFlag; }
		}

	///////////////////////////////////
	//	LineHeight
	//
	public
	int
	LineHeight {
		get { return lineHeight; }
		set { lineHeight = value; ItemHeight = (FontHeight * lineHeight) / 100; }
		}

	///////////////////////////////////
	//	FileName
	//
	public
	string
	FileName {
		get { return fileName; }
		}

	///////////////////////////////////
	//	MyTreeView()
	//
	public
	MyTreeView(
		ref StatusBarPanel		statusBarPanel1,
		ref StatusBarPanel		statusBarPanelZ,
		ref ContextMenu			contextMenu,
		ref string				versionNo,
		ref string				buildNo,
		ref string				programName) {

		this.statusBarPanel1 = statusBarPanel1;
		this.statusBarPanelZ = statusBarPanelZ;
		this.contextMenu = contextMenu;
		this.versionNo = versionNo;
		this.buildNo = buildNo;
		this.programName = programName;
		this.StrikeOutFont = new Font(this.Font, this.Font.Style | FontStyle.Strikeout);
		}

	///////////////////////////////////
	//	OnKeyPress()
	//
	//	* :
	//		- TreeView Էµ Ű óѴ.
	//
	protected override
	void 
	OnKeyPress(
		KeyPressEventArgs		e) {

		if( fileName != null ) {
			if( e.KeyChar != 'd' ) {
				DeleteLineFlag = false;
				}
			if( e.KeyChar != 'c' ) {
				CollapseAllFlag = false;
				}
			if( e.KeyChar != 'e' ) {
				ExpandAllFlag = false;
				}
			switch( e.KeyChar ) {
				case (char)Keys.Enter: EditSelectedNode(); break;
				case (char)Keys.Space: StrikeOutNode(); break;
				case 'a': AppendToSelectedNode(); break;
				case 'c': CollapseAllSelectedNode(); break;
				case 'd': DeleteSelectedNode(); break;
				case 'e': ExpandAllSelectedNode(); break;
				case 'f': ToggleExpandCollapse(); break;
				case 'i': InsertInFrontOfSelectedNode(); break;
				case 'o': InsertInBackOfSelectedNode(); break;
				case 'h': SelectParentNode(); break;
				case 'l': SelectChildNode(); break;
				case 'k': SelectPrevNode(); break;
				case 'j': SelectNextNode(); break;
				default: {
					// MessageBox.Show("Էµ Ű  '" + e.KeyChar.ToString() + "' ̴");
						// ̰ Ctrl+Up  Ű    . (2003.12.16)
						////////////
					break;
					}
				}
			}
		e.Handled = true;
		}

	///////////////////////////////////
	//	OnBeforeCollapse()
	//
	//	* :
	//		- 1 ذ  SelectedNode   Collapse ̺Ʈ ϵ Ѵ.
	//
	protected override
	void
	OnBeforeCollapse(
		TreeViewCancelEventArgs		e) {

		if( ToggleExpandCollapseFlag == true ) {
			if( e.Node == SelectedNode ) {
				e.Cancel = false;
				ToggleExpandCollapseFlag = false;
				}
			else {
				e.Cancel = true;
				}
			}
		//	1    ߰ ڵ
		//	MessageBox.Show("OnBeforeCollapse " + e.Node.ToString());
		}

	///////////////////////////////////
	//	OnAfterLabelEdit()
	//
	//	* :
	//		- 9 ذϱ ؼ   Ŀ ImeMode .
	//		-    ImeMode ڵ .
	//		-     ٸٸ changedFlag  true  ,
	//			statusBarPanelZ     ð( ð) Ѵ.
	//
	protected override
	void
	OnAfterLabelEdit(
		NodeLabelEditEventArgs		e) {

		ImeMode = ImeMode.Disable;

		if( e.Label != null && SelectedNode.Text != e.Label ) {
			changedFlag = true;
			statusBarPanelZ.ToolTipText = System.DateTime.Now.ToShortTimeString();
			}
		}

	///////////////////////////////////
	//	OnAfterCheck()
	//
	protected override
	void
	OnAfterCheck(
		TreeViewEventArgs			e) {

		if( flagUseStrikeOut == true ) {
			if( e.Node.Checked == true ) {
				e.Node.NodeFont = this.StrikeOutFont;
				}
			else {
				e.Node.NodeFont = this.Font;
				}
			}
		}

	///////////////////////////////////
	//	OnMouseDown()
	//
	protected override
	void
	OnMouseDown(
		MouseEventArgs					e) {

		if( e.Button == MouseButtons.Right ) {
			xyMouseDown.X = e.X;
			xyMouseDown.Y = e.Y;
			}
		}

	///////////////////////////////////
	//	OnMouseUp()
	//
	protected override
	void
	OnMouseUp(
		MouseEventArgs					e) {

		if(	e.Button == MouseButtons.Right
		&&	e.X == xyMouseDown.X && e.Y == xyMouseDown.Y
		&&	GetNodeAt(xyMouseDown) != null ) {

			SelectedNode = GetNodeAt(xyMouseDown);
			contextMenu.Show(this, xyMouseDown);
			}
		}

	///////////////////////////////////
	//	StrikeOutNode()
	//
	private
	void
	StrikeOutNode() {

		if( flagUseStrikeOut == true && CheckBoxes == false ) {
			if( SelectedNode.Checked == true ) {
				SelectedNode.Checked = false;
				SelectedNode.NodeFont = this.Font;
				}
			else {
				SelectedNode.Checked = true;
				SelectedNode.NodeFont = this.StrikeOutFont;
				}
			}
		}

	///////////////////////////////////
	//	SetStrikeOutFont()
	//
	public
	void
	SetStrikeOutFont(
		bool					flagUseStrikeOut) {

		this.flagUseStrikeOut = flagUseStrikeOut;

		BeginUpdate();
		SetStrikeOutFont_Recursion(Nodes[0]);
		EndUpdate();
		}

	private
	void
	SetStrikeOutFont_Recursion(
		TreeNode				treeNode) {

		if( treeNode.Checked == true ) {
			if( flagUseStrikeOut == true ) {
				treeNode.NodeFont = this.StrikeOutFont;
				}
			else {
				treeNode.NodeFont = this.Font;
				}
			}

		if( treeNode.Nodes.Count > 0 ) {
			foreach( TreeNode childNode in treeNode.Nodes ) {
				SetStrikeOutFont_Recursion(childNode);
				}
			}
		}

	///////////////////////////////////
	//	SetCheckBoxes()
	//
	//	* :
	//		- CheckBoxes  true Ǵ false  Ѵ.
	//		- Ÿӿ TreeView.CheckBoxes Ӽ ϸ Ʈ  Ʈϵ TreeView ڵ ٽ 
	//			(Control.RecreateHandle ).   õ TreeNode ϰ  Ʈ 尡 ҵǰ,
	//			 Ʈ  TreeNode.Checked  . (21)
	//		- 21 ذϱ ؼ ڵ ٽ   Checked  IsExpanded  ߴٰ ٽ Ѵ.
	//
	public
	void
	SetCheckBoxes(
		bool					flagCheckBoxes) {

		BeginUpdate();

		BackupCheckedAndIsExpanded();
		CheckBoxes = flagCheckBoxes;
		RestoreCheckedAndIsExpanded();

		EndUpdate();
		}

	///////////////////////////////////
	//	BackupCheckedAndIsExpanded()
	//
	//	* :
	//		-  TreeNode    Checked  Ѵ.
	//
	private
	void
	BackupCheckedAndIsExpanded() {

		queueChecked.Clear();
		queueIsExpanded.Clear();
		BackupCheckedAndIsExpanded_Recursion(Nodes[0]);
		}

	private
	void
	BackupCheckedAndIsExpanded_Recursion(
		TreeNode				treeNode) {

		queueChecked.Enqueue(treeNode.Checked);
		queueIsExpanded.Enqueue(treeNode.IsExpanded);
		if( treeNode.Nodes.Count > 0 ) {
			foreach( TreeNode childNode in treeNode.Nodes ) {
				BackupCheckedAndIsExpanded_Recursion(childNode);
				}
			}
		}

	///////////////////////////////////
	//	RestoreCheckedAndIsExpanded()
	//
	//	* :
	//		- ߴ Checked  Ѵ.
	//
	private
	void
	RestoreCheckedAndIsExpanded() {

		RestoreCheckedAndIsExpanded_Recursion(Nodes[0]);
		}

	private
	void
	RestoreCheckedAndIsExpanded_Recursion(
		TreeNode				treeNode) {

		if( queueChecked.Count > 0 ) {
			treeNode.Checked = (bool)queueChecked.Dequeue();
			if( (bool)queueIsExpanded.Dequeue() == true ) {
				treeNode.Expand();
				}
			if( treeNode.Nodes.Count > 0 ) {
				foreach( TreeNode childNode in treeNode.Nodes ) {
					RestoreCheckedAndIsExpanded_Recursion(childNode);
					}
				}
			}
		}

	///////////////////////////////////
	//	ClearAllWithFileName()
	//
	//	* :
	//		- TreeView   ϰ root   带 .
	//
	public
	void
	ClearAllWithFileName(
		string					newFileName) {

		fileName = newFileName;
		ClearAll();
		}

	///////////////////////////////////
	//	ClearAll()
	//
	//	* :
	//		- TreeView   ϰ root   带 .
	//
	public
	void
	ClearAll() {
		BeginUpdate();
		Nodes.Clear();
		Nodes.Add(new TreeNode(" "));
		EndUpdate();
		changedFlag = false;
		}

	///////////////////////////////////
	//	AppendToSelectedNode()
	//
	//	* :
	//		- SelectedNode ڽ 忡  带 ߰Ѵ.
	//
	public
	void
	AppendToSelectedNode() {
		TreeNode				newNode;

		newNode = new TreeNode(" ");
		SelectedNode.Nodes.Add(newNode);
		SelectedNode.Expand();
		newNode.BeginEdit();
		SelectedNode = newNode;
		changedFlag = true;
		}

	///////////////////////////////////
	//	CollapseAllSelectedNode()
	//
	//	* :
	//		- SelectedNode   带 Ѵ.
	//
	public
	void
	CollapseAllSelectedNode() {

		if( CollapseAllFlag == true ) {
			BeginUpdate();
			SelectedNode.Collapse();
				//	.NET 1.1  ׷ ̴  Collapse()  CollapseAll()   ϰ ִ.
				////////////
			EndUpdate();
			CollapseAllFlag = false;
			}
		else {
			CollapseAllFlag = true;
			}
		}

	///////////////////////////////////
	//	ExpandAllSelectedNode()
	//
	//	* :
	//		- SelectedNode   带 ȮѴ.
	//
	public
	void
	ExpandAllSelectedNode() {

		if( ExpandAllFlag == true ) {
			BeginUpdate();
			SelectedNode.ExpandAll();
			EndUpdate();
			ExpandAllFlag = false;
			}
		else {
			ExpandAllFlag = true;
			}
		}

	///////////////////////////////////
	//	DeleteSelectedNode()
	//
	//	* :
	//		- SelectedNode  Ѵ.
	//		- VI   'd' Ű    ǵ Ѵ.
	//

	private
	void
	DeleteSelectedNode() {
		if( DeleteLineFlag == true ) {
			if( SelectedNode != Nodes[0] ) {
				Nodes.Remove(SelectedNode);
				}
			DeleteLineFlag = false;
			}
		else {
			DeleteLineFlag = true;
			}
		}

	///////////////////////////////////
	//	EditSelectedNode()
	//
	//	* :
	//		- SelectedNode Ѵ.
	//
	public
	void
	EditSelectedNode() {

		SelectedNode.BeginEdit();
		}

	///////////////////////////////////
	//	InsertInFrontOfSelectedNode()
	//
	//	* :
	//		- SelectedNode տ   Ѵ.
	//
	public
	void
	InsertInFrontOfSelectedNode() {
		if( SelectedNode != Nodes[0] ) {
			TreeNode			newNode;

			newNode = new TreeNode(" ");
			SelectedNode.Parent.Nodes.Insert(SelectedNode.Index, newNode);
			newNode.BeginEdit();
			SelectedNode = newNode;
			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	InsertInBackOfSelectedNode()
	//
	//	* :
	//		- SelectedNode ڿ   Ѵ.
	//
	public
	void
	InsertInBackOfSelectedNode() {
		if( SelectedNode != Nodes[0] ) {
			TreeNode			newNode;

			newNode = new TreeNode(" ");
			SelectedNode.Parent.Nodes.Insert(SelectedNode.Index + 1, newNode);
			newNode.BeginEdit();
			SelectedNode = newNode;
			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	SelectParentNode()
	//
	//	* :
	//		- SelectedNode ҵǾ  ʴٸ SelectedNode Ѵ.
	//		- SelectedNode ҵǾ ִٸ θ 带 SelectedNode Ѵ.
	//		- SelectedNode root node  ƹϵ  ʴ´.
	//
	public
	void
	SelectParentNode() {
		if(	SelectedNode.Nodes.Count > 0 && SelectedNode.IsExpanded ) {
			ToggleExpandCollapse();
			}
		else
		if( SelectedNode != Nodes[0] ) {
			SelectedNode = SelectedNode.Parent;
			}
		}

	///////////////////////////////////
	//	SelectChildNode()
	//
	//	* :
	//		- SelectedNode ȮǾ  ʴٸ SelectedNode ȮѴ.
	//		- SelectedNode ȮǾ ִٸ ڽ 带 SelectedNode Ѵ.
	//		- SelectedNode ڽ 带   ʴٸ ƹϵ  ʴ´.
	//
	public
	void
	SelectChildNode() {
		if( SelectedNode.Nodes.Count > 0 ) {
			if( SelectedNode.IsExpanded ) {
				SelectNextNode();
				}
			else {
				ToggleExpandCollapse();
				}
			}
		}

	///////////////////////////////////
	//	SelectPrevNode()
	//
	//	* :
	//		- SelectedNode  带 SelectedNode Ѵ.
	public
	void
	SelectPrevNode() {
		if( SelectedNode.PrevVisibleNode != null ) {
			SelectedNode = SelectedNode.PrevVisibleNode;
			}
		}

	///////////////////////////////////
	//	SelectNextNode()
	//
	//	* :
	//		- SelectedNode  带 SelectedNode Ѵ.
	public
	void
	SelectNextNode() {
		if( SelectedNode.NextVisibleNode != null ) {
			SelectedNode = SelectedNode.NextVisibleNode;
			}
		}

	///////////////////////////////////
	//	ToggleExpandedCollapse()
	//
	//	* :
	//		- SelectedNode Ȯ ¸ Ѵ.
	//		- ڽĳ Ȯ ¿  ġ ʴ´.
	//	* :
	//		- 1
	//
	public
	void
	ToggleExpandCollapse() {
		ToggleExpandCollapseFlag = true;
		BeginUpdate();
		SelectedNode.Toggle();
		EndUpdate();
		ToggleExpandCollapseFlag = false;
		changedFlag = true;
		}

	///////////////////////////////////
	//	MoveSelectedNodeToUp()
	//
	//	* :
	//		- SelectedNode SelectedNode.PrevNode  ű.
	//		- SelectedNode SelectedNode.PrevNode ڽĳ Ȯ ¿  ġ ʴ´.
	//	* :
	//		- 2
	//
	public
	void
	MoveSelectedNodeToUp() {

		if( SelectedNode.Index > 0 ) {
			TreeNode				clonedNode;

			clonedNode = CreateClonedNode(SelectedNode);

			//	2 Ȳ ľϱ  ߰ ڵ
			//	MessageBox.Show(
			//		"ClondeNode.IsExpanded " + clonedNode.IsExpanded.ToString() + "\n" +
			//		"SelectedNode.IsExpanded " + SelectedNode.IsExpanded.ToString()
			//		);
			BeginUpdate();
			SelectedNode.Parent.Nodes.Insert(SelectedNode.Index - 1, clonedNode);
			Nodes.Remove(SelectedNode);
			EndUpdate();
			SelectedNode = clonedNode;

			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	MoveSelectedNodeToDown()
	//
	//	* :
	//		- SelectedNode SelectedNode.NextNode  ű.
	//		- SelectedNode SelectedNode.NextNode ڽĳ Ȯ ¿  ġ ʴ´.
	//	* :
	//		- 2
	//
	public
	void
	MoveSelectedNodeToDown() {

		if( SelectedNode.NextNode != null ) {
			TreeNode				clonedNode;

 			clonedNode = CreateClonedNode(SelectedNode.NextNode);
 			BeginUpdate();
			SelectedNode.Parent.Nodes.Insert(SelectedNode.Index, clonedNode);
			Nodes.Remove(SelectedNode.NextNode);
			EndUpdate();

			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	MoveSelectedNodeToParent()
	//
	//	* :
	//		- õ 带 θ   ű.
	//	* :
	//		- õ  root node  ƴϾ Ѵ.
	//		- õ  Parent  root node  ƴϾ Ѵ.
	//
	public
	void
	MoveSelectedNodeToParent() {

		if(	SelectedNode != Nodes[0] 
		&&	SelectedNode.Parent != Nodes[0] ) {

			TreeNode				clonedNode;

			clonedNode = CreateClonedNode(SelectedNode);
			BeginUpdate();
			SelectedNode.Parent.Parent.Nodes.Insert(SelectedNode.Parent.Index + 1, clonedNode);
			Nodes.Remove(SelectedNode);
			EndUpdate();
			SelectedNode = clonedNode;

			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	MoveSelectedNodeToChild()
	//
	//	* :
	//		- õ 带   ڽ ű.
	//	* :
	//		- õ   带  ־ Ѵ.
	//	
	public
	void
	MoveSelectedNodeToChild() {

		if(	SelectedNode.Index > 0 ) {

			TreeNode				clonedNode;

			clonedNode = CreateClonedNode(SelectedNode);
			BeginUpdate();
			SelectedNode.PrevNode.Nodes.Add(clonedNode);
			Nodes.Remove(SelectedNode);
			EndUpdate();
			SelectedNode = clonedNode;

			changedFlag = true;
			}
		}

	///////////////////////////////////
	//	CreateClonedNode()
	//
	//	* :
	//		-   .
	//		-   Ȯ ´   .
	//
	private
	TreeNode
	CreateClonedNode(
		TreeNode				originalNode) {

		TreeNode				clonedNode;

		clonedNode = (TreeNode) originalNode.Clone();
		if( originalNode.IsExpanded == true ) {
			clonedNode.Expand();
			MakeSameExpandStateOfChild(clonedNode, originalNode);
			}

		return clonedNode;
		}

	///////////////////////////////////
	//	MakeSameExpandStateOfChild()
	//
	//	* :
	//		-     ڽ  Ȯ ¸ ϰ .
	//
	private
	void
	MakeSameExpandStateOfChild(
		TreeNode				clonedNode,
		TreeNode				originalNode) {

		for( int i = 0; i < originalNode.Nodes.Count; i++ ) {
			if( originalNode.Nodes[i].IsExpanded == true ) {
				clonedNode.Nodes[i].Expand();
				MakeSameExpandStateOfChild(clonedNode.Nodes[i], originalNode.Nodes[i]);
				}
			}
		}

	///////////////////////////////////
	//	LoadTree()
	//
	//	* :
	//		-  ̸ ־ ش  о TreeView .
	//
	public
	void
	LoadTree(
		string					loadFileName) {

		XmlDocument				newXmlDocument;

		newXmlDocument = new XmlDocument();
		fileName = loadFileName;
		newXmlDocument.Load(fileName);

		BeginUpdate();
		Nodes.Clear();
		BuildTree(Nodes, newXmlDocument.DocumentElement);
		SelectedNode = Nodes[0];
		EndUpdate();

		changedFlag = false;
		}

	///////////////////////////////////
	//	BuildTree()
	//
	//	* :
	//		- root node    BuildTreeRecursion() ȣϿ TreeView Ѵ.
	//
	private
	void
	BuildTree(
		TreeNodeCollection		parentNodeCollection,
		XmlNode					xmlNode) {

		if( xmlNode != null ) {
			TreeNode			childNode;

			childNode = new TreeNode(xmlNode.Attributes["title"].Value);
			parentNodeCollection.Add(childNode);

			LineHeight = Convert.ToInt32(xmlNode.Attributes["line-height"].Value);

			if( xmlNode.Attributes["check-boxes"] != null ) {
				CheckBoxes = xmlNode.Attributes["check-boxes"].Value == "1" ? true : false;
				}
			else {
				CheckBoxes = false;
				}

			if( xmlNode.Attributes["strikeout"] != null ) {
				flagUseStrikeOut = xmlNode.Attributes["strikeout"].Value == "1" ? true : false;
				}
			else {
				flagUseStrikeOut = false;
				}

			if( xmlNode.Attributes["checked"] != null ) {
				childNode.Checked = xmlNode.Attributes["checked"].Value == "1" ? true : false;
				}
			else {
				childNode.Checked = false;
				}

			foreach( XmlNode childXmlNode in xmlNode.ChildNodes ) {
				BuildTreeRecursion(childNode.Nodes, childXmlNode);
				}
			if( xmlNode.Attributes["expanded"].Value == "1" ) {
				childNode.Expand();
				}
			}
		}	

	///////////////////////////////////
	//	BuildTreeRecursion()
	//
	//	* :
	//		-  ȣϸ鼭 TreeView Ѵ.
	//
	private
	void
	BuildTreeRecursion(
		TreeNodeCollection		parentNodeCollection,
		XmlNode					xmlNode) {

		if( xmlNode != null ) {
			TreeNode			childNode;

			childNode = new TreeNode(xmlNode.Attributes["title"].Value);
			parentNodeCollection.Add(childNode);

			if( xmlNode.Attributes["checked"].Value == "1" ) {
				childNode.Checked = true;
				}
			foreach( XmlNode childXmlNode in xmlNode.ChildNodes ) {
				BuildTreeRecursion(childNode.Nodes, childXmlNode);
				}
			if( xmlNode.Attributes["expanded"].Value == "1" ) {
				childNode.Expand();
				}
			}
		}	

	///////////////////////////////////
	//	SaveTree()
	//
	//	* :
	//		- fileName  ̸  ۼϰ ִ TreeView Ѵ.
	//
	public
	void
	SaveTree() {

		if( fileName != null ) {
			SaveTreeAsXml(fileName);
			}
		}

	///////////////////////////////////
	//	SaveTreeAsXml()
	//
	//	* :
	//		-  ۼϰ ִ TreeView XML  Ѵ.
	//
	public
	void
	SaveTreeAsXml(
		string					saveFileName) {

		XmlDocument				newXmlDocument;

		newXmlDocument = new XmlDocument();
		fileName = saveFileName;
		BuildXmlDocument(newXmlDocument);
		newXmlDocument.Save(fileName);

		changedFlag = false;
		}

	///////////////////////////////////
	//	BuildXmlDocument()
	//
	//	* :
	//
	private
	void
	BuildXmlDocument(
		XmlDocument				xmlDocument) {

		// root element  .
		xmlDocument.LoadXml(
			"<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + 
			"<node title=\"" + Nodes[0].Text + "\"" + 
				" line-height=\"" + LineHeight + "\"" +
				" check-boxes=\"" + (CheckBoxes ? "1" : "0") + "\"" +
				" strikeout=\"" + (flagUseStrikeOut ? "1" : "0") + "\"" +
				" />"
			);

		SetXmlExpandedAttribute(xmlDocument, xmlDocument.DocumentElement, Nodes[0].IsExpanded);
		SetXmlCheckedAttribute(xmlDocument, xmlDocument.DocumentElement, Nodes[0].Checked);

		foreach( TreeNode treeNode in Nodes[0].Nodes ) {
			XmlElement			xmlElement;

			xmlElement = xmlDocument.CreateElement("node");
			BuildXmlElementFromTreeNode(xmlDocument, xmlElement, treeNode);
			xmlDocument.DocumentElement.AppendChild(xmlElement);
			}
		}

	///////////////////////////////////
	//	BuildXmlElementFromTreeNode()
	//
	//	* :
	//		-  ȣϸ鼭 XmlDocument Ѵ.
	//
	private
	void
	BuildXmlElementFromTreeNode(
		XmlDocument				xmlDocument,
		XmlElement				xmlElement,
		TreeNode				treeNode) {

		SetXmlTitleAttribute(xmlDocument, xmlElement, treeNode.Text);
		SetXmlExpandedAttribute(xmlDocument, xmlElement, treeNode.IsExpanded);
		SetXmlCheckedAttribute(xmlDocument, xmlElement, treeNode.Checked);

		foreach( TreeNode childNode in treeNode.Nodes ) {
			XmlElement			childXmlElement;

			childXmlElement = xmlDocument.CreateElement("node");
			BuildXmlElementFromTreeNode(xmlDocument, childXmlElement, childNode);
			xmlElement.AppendChild(childXmlElement);
			}
		}

	///////////////////////////////////
	//	SetXmlTitleAttribute()
	//
	//	* :
	//		- xmlElement title Ӽ ߰Ѵ.
	//
	private
	void
	SetXmlTitleAttribute(
		XmlDocument				xmlDocument,
		XmlElement				xmlElement,
		string					title) {

		SetXmlAttribute(xmlDocument, xmlElement, "title", title);
		}

	///////////////////////////////////
	//	SetXmlExpandedAttribute()
	//
	//	* :
	//		- xmlElement expanded Ӽ ߰Ѵ.
	private
	void
	SetXmlExpandedAttribute(
		XmlDocument				xmlDocument,
		XmlElement				xmlElement,
		bool					isExpanded) {

		SetXmlAttribute(xmlDocument, xmlElement, "expanded", (isExpanded) ? "1" : "0");
		}

	///////////////////////////////////
	//	SetXmlCheckedAttribute()
	//
	//	* :
	//		- xmlElement checked Ӽ ߰Ѵ.
	private
	void
	SetXmlCheckedAttribute(
		XmlDocument				xmlDocument,
		XmlElement				xmlElement,
		bool					flagChecked) {

		SetXmlAttribute(xmlDocument, xmlElement, "checked", (flagChecked) ? "1" : "0");
		}

	///////////////////////////////////
	//	SetXmlAttribute()
	//
	//	* :
	//		- xmlElement Ӽ ߰Ѵ.
	//
	private
	void
	SetXmlAttribute(
		XmlDocument				xmlDocument,
		XmlElement				xmlElement,
		string					attributeName,
		string					attributeValue) {

		XmlAttribute			xmlAttribute;

		xmlAttribute = xmlDocument.CreateAttribute(attributeName);
		xmlAttribute.Value = attributeValue;
		xmlElement.SetAttributeNode(xmlAttribute);		
		}

	///////////////////////////////////
	//	ExportAsHtml()
	//
	//	* :
	//		-  ۼϰ ִ TreeView HTML  Ѵ.
	//
	public
	void
	ExportAsHtml(
		string					saveFileName) {

		StreamWriter			stream;

		if( File.Exists(saveFileName) ) {
			File.Delete(saveFileName);
			}
		stream = new StreamWriter(File.OpenWrite(saveFileName));
		BuildHtmlDocument(stream);
		stream.Close();
		}

	///////////////////////////////////
	//	BuildHtmlDocument()
	//
	//	* :
	//
	private
	void
	BuildHtmlDocument(
		StreamWriter			stream) {

		WriteHtmlBegin(stream);
		BuildHtmlElementFromTreeNode(stream, Nodes[0], 0);
		WriteHtmlEnd(stream);
		}

	///////////////////////////////////
	//	WriteHtmlBegin()
	//
	private
	void
	WriteHtmlBegin(
		StreamWriter			stream) {

		stream.WriteLine("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
		stream.WriteLine("<!-- saved by " + programName + " Version " + versionNo + " Build " + buildNo + " -->");
		stream.WriteLine("<HTML>");
		stream.WriteLine("<HEAD>");
		stream.WriteLine("  <TITLE>" + Nodes[0].Text + "</TITLE>");
		stream.WriteLine("  <META http-equiv=Content-Type content=\"text/html; charset=utf-8\">");
		stream.WriteLine("  <STYLE type=\"text/css\">");
		stream.WriteLine("    body, li, p { color:black; background-color:white; line-height:" + LineHeight + "%; }");
		stream.WriteLine("  </STYLE>");
		stream.WriteLine("</HEAD>");
		stream.WriteLine("<BODY>");
		stream.WriteLine("<UL>");
		}

	///////////////////////////////////
	//	WriteHtmlEnd()
	//
	private
	void
	WriteHtmlEnd(
		StreamWriter			stream) {

		stream.WriteLine("</UL>");
		stream.WriteLine("</BODY>");
		stream.WriteLine("</HTML>");
		}

	///////////////////////////////////
	//	BuildHtmlElementFromTreeNode()
	//
	//	* :
	//		- treeNode    stream Ѵ.
	//
	private
	void
	BuildHtmlElementFromTreeNode(
		StreamWriter			stream,
		TreeNode				treeNode,
		int						indentCount) {

		MakeIndent(stream, indentCount);
		if( CheckBoxes ) {
			stream.WriteLine("<LI><TT>[" + ((treeNode.Checked) ? "x" : "_") + "]</TT> " + treeNode.Text);
			}
		else {
			stream.WriteLine("<LI>" + treeNode.Text);
			}

		if( treeNode.Nodes.Count > 0 ) {
			MakeIndent(stream, indentCount);
			stream.WriteLine("<UL>");

			foreach( TreeNode childNode in treeNode.Nodes ) {
				BuildHtmlElementFromTreeNode(stream, childNode, indentCount + 1);
				}

			MakeIndent(stream, indentCount);
			stream.WriteLine("</UL>");
			}
		}

	///////////////////////////////////
	//	ExportAsText()
	//
	//	* :
	//		-  ۼϰ ִ TreeView TEXT  Ѵ.
	//
	public
	void
	ExportAsText(
		string					saveFileName) {

		StreamWriter			stream;

		if( File.Exists(saveFileName) ) {
			File.Delete(saveFileName);
			}
		stream = new StreamWriter(File.OpenWrite(saveFileName));
		BuildTxtElementFromTreeNode(stream, Nodes[0], 0);
		stream.Close();
		}

	///////////////////////////////////
	//	BuildTxtElementFromTreeNode()
	//
	//	* :
	//		- treeNode    stream Ѵ.
	//
	private
	void
	BuildTxtElementFromTreeNode(
		StreamWriter			stream,
		TreeNode				treeNode,
		int						indentCount) {

		MakeIndent(stream, indentCount);
		indentCount++;
		if( CheckBoxes ) {
			stream.WriteLine("* [" + ((treeNode.Checked) ? "x" : "_") + "] " + treeNode.Text);
			}
		else {
			stream.WriteLine("* " + treeNode.Text);
			}

		foreach( TreeNode childNode in treeNode.Nodes ) {
			BuildTxtElementFromTreeNode(stream, childNode, indentCount);
			}
		}

	///////////////////////////////////
	//	MakeIndent()
	//
	//	* :
	//		- indentCount ŭ 鿩⸦ Ѵ.
	//
	private
	void
	MakeIndent(
		StreamWriter			stream,
		int						indentCount) {

		for( int i = 0; i < indentCount; i++ ) {
			stream.Write("  ");
			}
		}

	}
//
//	End of class MyTreeView
///////////////////////////////////////////////////////////////////////////////
