<?php

/*
=== Z3A2 ڵ ===

// @ : 2008-8-22
// @ : ŵ  <.)++++<  budl 
// @ : ikw3179@naver.com
// @۱ : GPL

// @Z3A2 ڵĿ   ũ : http://wiki.kldp.org/wiki.php/Z3A2


Z3A2 H3Z2   ڵ ü 1byte Ǵ 2byte   (2,3) ĺ ȯݴϴ.
Z3A2 1byte  2byte  ϱ ؼ  65792( 256 + 65536 )  մϴ.   ڿ Ǵ ̳ʸ
 2byte  1byte  ó  ֽϴ.    NULL Ʈ  ó  ְ ˴ϴ.
ϰ Ǵ    Ŀ  ĺ  մϴ.

   24*52*52 + 28*32  = 256 + 65536 = 65792
  ǥ :  "/ [O-Z][A-Z][A-Z] | [A-N][A-P] /"    
   
 Ŀ 24 28  52 ĺ ҹհ ϹǷ  ߺ ʰ   ְ ù ĺ  
3 հ 2  Ǵ  ְ ȴ. ( [A-N]  [O-Z] ġ κ . )

 ڸ ĺ     ˴ϴ.

  [O-Z] = "OoPpQqRrSsTtUuVvWwXxYyZz" ;
  [A-N] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNn" ;
  [A-Z][A-P] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"   ;

1byte 0 'AA' Ǹ  2byte  65536  'zzz' ˴ϴ.

 * AA~dp  :  [1byte]  0 ~ 256
 * EA~zzz  :  [2byte] 0 ~ 65536
 
H3Z2   Z3A2  ĺ Ͽ ڵϱ    پ  մϴ.
θ̳ ϸ ϴ  ϸ α׷ ҽϿ ĺ ո 
Ǿ   ū     ֽϴ.

*/

define( Z3A2_DIV, 896 ) ; //Ӱ谪  28*32
define( Z3A2_MAX, 65792 ) ; //Ѱ谪   65792 = 65536 + 256  

$Z3A2[Z] = "OoPpQqRrSsTtUuVvWwXxYyZz" ;
$Z3A2[N] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNn" ;
$Z3A2[A] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"   ;
$Z3A2_D = array() ;

class  z3a2
{

////-------------  ENCODE ---------------/////

	//$input  ̳ʸ 
	function	encode( $input )
	{
		//̳ʸ,ڿΰ ڹ迭 ȯ 
		if( is_string( $input ))
		{				
			//ڿ 2byte     1byte  ִٸ   .
			$len = strlen( $input ) ;
			
			if( $len % 2 ) 
			{	//Ȧ     1BYTE
				$last_char_val = ord( $input{ $len -1 } ) ;
			}
					
			$input = unpack( 'v*' , $input );
			
			//   256 Ű 
			foreach( $input as $v )
			{ 				
				z3a2::encode_core( $Rstr , $v +256 ) ;
			}
			
			// Ʈ  ߰Ѵ.
			if( $last_char_val ) z3a2::encode_core( $Rstr , $last_char_val ) ; 
		}
	    else if ( is_array( $input ) ) // 迭
	    {
			foreach( $input as $a )
				z3a2::encode_core( $Rstr , $a ) ;
	    }
	    else if ( is_int ( $input )) // 
			z3a2::encode_core( $Rstr , $input ) ;
	  
	    else  trigger_error("Է°( $input ) ȿ  [".__FUNCTION__."]", E_USER_ERROR );
		
		return $Rstr ;
		
	}
	
	function	encode_core( &$rstr , $codeVal )
	{
		global  $Z3A2 ;
		
		// Է°  0  65792  ̸ ̿ Ѵ. 
		if( $codeVal < 0  ||  $codeVal >= Z3A2_MAX ) // 65792 = 65536 + 256 
		trigger_error("谪( 0 ~ 65791 )  ġ \$codeVal = $codeVal [".__FUNCTION__."]", E_USER_ERROR );		
		
		
		
		if( $codeVal < Z3A2_DIV  ) // $codeVal < 896  ; 
		{
		  $rstr  .=  $Z3A2[N][ intval( $codeVal / 32 ) ].
					  $Z3A2[A][ $codeVal %32  ] ;
		}
		else{  // >= 896
		$codeVal  -=  Z3A2_DIV  ;

		$midVal  = intval( $codeVal / 2704 );//2704 = 52*52
		$midRem  = $codeVal % 2704   ;

		$rstr  .=   $Z3A2[Z][ $midVal   ]. 
					$Z3A2[A][ intval( $midRem / 52 ) ].  
					$Z3A2[A][ $midRem % 52  ] ;
		}  
		//return 1 ; 
	}
	
	
	
////-------------  DECODE ---------------/////

	/// @function decode  Z3A2 ڿ  迭 Ǵ  ̳ʸ ȯѴ.
	/// $mode  true ̸ ̳ʸ ȯ 
	/// $mode  false  ̸ 迭 ȯ 
	function 	decode(  $z3a2str , $mode = true  )
	{	
		global	$Z3A2	;
		
		$Rary = array() ;
		$R = "" ; 	  
	  
		for($i = 0 ;  
			// (.)  ġ ʴ κ ġϴ  
			//\Gɼ Ͽ ڿ ۺκ ġǵؾ Ѵ. ^ Ҽ .
			///[O-Z][A-Z][A-Z]|[A-N][A-P]/
			preg_match( "/\G(?:([O-Z])[A-Z][A-Z]|[A-N][A-P]|(.))/i" 
						, $z3a2str , $match , 0 , $i ) ;
						
			$i += strlen( $match[0] ) )
		{	  
			if( $match[2] ){ //(.) 
			/////////////////////////////////////
				print $R  . ": " .strlen( $z3a2str ) ." :" ; 
				trigger_error("Է Z3A2ڵ( $z3a2str , $i:$match[2] ) Ͽ  [".__FUNCTION__."]" , E_USER_ERROR ) ;
			}
		    
			//$match[1]   $match[0]  [O-Z] ϴ Ǵϱ   
		    $dcode  = z3a2::decode_core( $match[0] , $match[1] )   ;
			
			if( $mode )
			{				
				if( $dcode <= 256 ) // 256
					$R .= chr( $dcode ) ; //pack( "C" , $dcode )	;
				else if( $dcode <= Z3A2_MAX )
					$R .= pack( "v" , $dcode - 256  )	;
				
			}else array_push( $Rary , $dcode )	;
		    
		}
		
		if( $mode )	return $R	;
		else 		return $Rary	;
		
	} //  function 	decode( $z3a2str , $mode = 1  ) 
	
	function	decode_init( )
	{		
		global  $Z3A2  , $Z3A2_D ;
		
		if( $Z3A2_D ) return ;
		
		//print "INIT D INIT D INIT D INIT D <br>";

		$Z3A2_D[Z] = array();
		$Z3A2_D[N] = array();
		$Z3A2_D[A] = array();

		foreach( $Z3A2 as  $key => $val )
		{
			for( $i = 0 ; $i < strlen($Z3A2[$key]); $i++ )
			{
			  $Z3A2_D[$key][$val[$i]] = $i ; 
			}  
		}
	}	
	
	// $Z_mode  true ̸  [O-Z]   
	function decode_core( $ecode , $Z_mode )
	{  		
		global  $Z3A2_D  ;

		$rVal = 0 ;
		
		///[O-Z][A-Z][A-Z]|[A-N][A-P]/		
		if( $Z_mode )
		{	
			$rVal =   $Z3A2_D[Z][$ecode{0}]*2704 //2704 = 52*52
				+ $Z3A2_D[A][$ecode{1}]*52
				+ $Z3A2_D[A][$ecode{2}] 
				+ Z3A2_DIV ; // 896 					
		}		
		else 
		{	
			$rVal =   $Z3A2_D[N][$ecode{0}]*32 
				+ $Z3A2_D[A][$ecode{1}] ; 
			
		}
		
		return  $rVal ;
	}
}

z3a2::decode_init( ); 