#include <glib-object.h>

#define ADDRESS_TYPE_ENTRY (address_entry_get_type ())

typedef struct AddressEntry AddressEntry;

struct AddressEntry
{
  guint ref_count;
  
  char *firstname;
  char *lastname;
  char *address;

  int month;
  int day;
};

GType         address_entry_get_type (void);
AddressEntry *address_entry_new      (void);
AddressEntry *address_entry_ref      (AddressEntry *entry);
void          address_entry_unref    (AddressEntry *entry);

void address_entry_set_firstname (AddressEntry *entry,
				  const char   *firstname);
void address_entry_set_lastname  (AddressEntry *entry,
				  const char   *lastname);
void address_entry_set_address   (AddressEntry *entry,
				  const char   *address);

gboolean address_entry_read_file (const gchar *filename,
				  GList      **entries_out,
				  GError     **error);
gboolean address_entry_write_file (const gchar *filename,
				   GList       *entries,
				   GError     **error);
