#include <gtk/gtk.h>

static void hello_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *dialog =
	gtk_message_dialog_new(GTK_WINDOW(user_data),
			       GTK_DIALOG_DESTROY_WITH_PARENT,
			       GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
			       "Hello,GTK+!");
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

int main(int argc, char **argv)
{
    GtkWidget *window, *button;

    gtk_init(&argc, &argv);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);

    button = gtk_button_new_with_label("Hello,GTK+!");
    g_signal_connect(button, "clicked", G_CALLBACK(hello_clicked), window);

    gtk_container_add(GTK_CONTAINER(window), button);
    gtk_widget_show_all(window);

    gtk_main();

    return 0;
}
