#include "config.h"
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <libintl.h>
#include <locale.h>

#define _(text) gettext(text)

void hello_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *dialog =
	gtk_message_dialog_new(GTK_WINDOW(user_data),
			       GTK_DIALOG_DESTROY_WITH_PARENT,
			       GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
			       _("Hello,Glade!"));
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

int main(int argc, char **argv)
{
    GladeXML *glade;

#ifdef ENABLE_NLS
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_init(&argc, &argv);

    gtk_window_set_default_icon_from_file(PIXMAPS_DIR "/hello.png", NULL);

    glade = glade_xml_new(GLADE_DIR "/hello.glade", "window1", NULL);
    glade_xml_signal_autoconnect(glade);

    gtk_main();

    return 0;
}
