/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#ifndef _ROUTINES_H
#define _ROUTINES_H

#include "general.h"
#include <stdio.h>

#ifndef ALLOC_LIST
# define xMalloc(n,Type)    (Type *)eMalloc((size_t)(n) * sizeof (Type))
# define xCalloc(n,Type)    (Type *)eCalloc((size_t)(n), sizeof (Type))
# define xRealloc(p,n,Type) (Type *)eRealloc((p), (n) * sizeof (Type))
# define eFree(p)	    Free(p)
#else
# define xMalloc(n,Type)    (Type *)dMalloc((size_t)(n) * sizeof (Type), __FILE__ , __LINE__)
# define xCalloc(n,Type)    (Type *)dCalloc((size_t)(n), sizeof (Type), __FILE__, __LINE__ )
# define xRealloc(p,n,Type) (Type *)dRealloc((p), (n) * sizeof (Type), __FILE__, __LINE__)
# define eFree(p)	    dFree(p , __FILE__, __LINE__)
#endif

#define PATH_SEPARATOR '/'
#define OUTPUT_PATH_SEPARATOR	PATH_SEPARATOR

#define DIR_MODE S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH
extern char *CurrentDirectory;
typedef int errorSelection;
enum eErrorTypes { FATAL = 1, WARNING = 2, PERROR = 4 };

typedef struct {
	/* Name of file for which status is valid */
    char* name;

	/* Does file exist? If not, members below do not contain valid data. */
    boolean exists;

	/* is file path a symbolic link to another file? */
    boolean isSymbolicLink;

	/* Is file (pointed to) a directory? */
    boolean isDirectory;

	/* Is file (pointed to) a normal file? */
    boolean isNormalFile;

	/* Is file (pointed to) executable? */
    boolean isExecutable;

	/* Is file (pointed to) setuid? */
    boolean isSetuid;

	/* Size of file (pointed to) */
    unsigned long size;
} fileStatus; 

extern void error (const errorSelection selection, const char *const format, ...) __printf__ (2, 3);

/* Memory allocation functions */
#ifdef NEED_PROTO_MALLOC
extern void *malloc (size_t);
extern void *realloc (void *ptr, size_t);
#endif
extern void *eMalloc (const size_t size);
extern void *eCalloc (const size_t count, const size_t size);
extern void *eRealloc (void *const ptr, const size_t size);
extern void Free( void *const ptr);

extern void *dMalloc (const size_t size , const char *file, int line);
extern void *dCalloc (const size_t count, const size_t size , const char *file , int line);
extern void *dRealloc (void *const ptr, const size_t size , const char *file, int line);
extern void dFree (void *const ptr , const char *file, int line);
extern void showUnfreeMem();

/* String manipulation functions */
extern int struppercmp (const char *s1, const char *s2);
extern int strnuppercmp (const char *s1, const char *s2, size_t n);
extern char* eStrdup (const char* str);

/* File system functions */
extern void setCurrentDirectory (void);
extern fileStatus *eStat (const char *const fileName);
extern void eStatFree( fileStatus *stat);
extern boolean doesFileExist (const char *const fileName);
extern boolean isSameFile (const char *const name1, const char *const name2);
extern const char *baseFilename (const char *const filePath);
extern const char *fileExtension (const char *const fileName);
extern boolean isAbsolutePath (const char *const path);
extern char* absoluteFilename (const char *file);
extern char* absoluteDirname (const char *file);
/*
   (gdb) print relativeFilename("/a/b/c","/a/b/") 
   $4 = 0x804fde0 "c"
   (gdb) print relativeFilename("/a/b/","/a/b/")
   $5 = 0x804fe10 ""
   (gdb) print relativeFilename("/a/b","/a/b/")
   $6 = 0x804fe40 "../b"
   (gdb) print relativeFilename("/b","/a/b/")
   $7 = 0x804fe70 "../../b"
   (gdb) print relativeFilename("/a/b/","/a/b/")
*/
extern char* relativeFilename (const char *file, const char *dir);
extern void createRecursiveDir ( const char *const target );
extern boolean is_binary( const char *fname );
extern int ungets  ( const char *str ,FILE *fd);

extern const char *get_base_dir( const char *const dir_name );
extern const char *get_base_file( const char *const dir_name );
extern const char *remove_html_ext( const char *const file_name );
extern char *get_common_dir(const char *const file1, const char *const file2);
extern char *get_dir_name( const char *const fname );

#endif	/* _ROUTINES_H */

/* vi:set tabstop=8 shiftwidth=4: */
