/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#ifndef _KEYWORD_H
#define _KEYWORD_H

/*
*   INCLUDE FILES
*/
#include "general.h"	/* must always come first */
#include "pltable.h"

/*
*   FUNCTION PROTOTYPES
*/

typedef struct sEntryContent
{
    const char	*source;
    int	    line;
    int	    value;
    char    type;
    struct sEntryContent    *next;
    const char	*itsDir;
    const char	*struct_name;
    boolean it_self;
} entryContent;

extern boolean is_global (const char *const keyword, const char *const source,
			lang_type language,char type, int line );
extern entryContent itself;
typedef enum Scope{ Global, Static }scope;
extern void addKeyword (const char *const keyword, const char *const source, const char *const struct_name,
			lang_type language,char type, int line, scope s, int value);
extern int lookupKeyword (const char *const keyword, int line, 
	const char *const source, lang_type language, const entryContent **content, boolean in_element);
extern void freeKeywordTable (void);
#ifdef DEBUG
extern void printKeywordTable (void);
#endif

#endif	/* _KEYWORD_H */

