/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/

#ifndef _FILE_LIST_H
#define _FILE_LIST_H

#include "general.h"
#include "routines.h"
#include "pltable.h"

/*
   file_list queue   Ǿ ִ.
    html_dir  η Ǿִ.
*/

typedef struct File_Entry
{
    fileStatus *status;
    lang_type language;
    //char *its_dir;
    char *relative_fname;
    char *absolute_fname;
    char *relative_dir;
    char *path_upto_htmldir;
    boolean is_I;
    boolean is_R;
    struct File_Entry *next;
}file_entry;

extern file_entry binary_file;

extern char *get_path_upto_htmldir( const char *fname );
extern file_entry * create_file_entry( const char *const fname, boolean I, boolean R );
extern void free_file_entry( file_entry *entry );
extern	void	    insert_file_entry( file_entry *entry);
extern	file_entry  *get_file_entry(void);
extern	boolean	    is_exist_in_filelist( const char *const fname );
extern void print_file_list();
extern lang_type get_lang_type_with_content( const char *fname);
extern boolean is_ignore_list( lang_type lang);



#endif
