/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "routines.h"
#include "filelist.h"
#include "makehtml.h"
#include "debug.h"
#include "option.h"

#include <stdio.h>
#include <string.h>
#include <unistd.h>


static file_entry *head = NULL;
static file_entry *tail = NULL;

/*
   fname ݵ html丮 ο Ѵ.
 */
extern char *get_path_upto_htmldir( const char *fname )
{
    int i,ptr=0;
    char buf[BUF_MAX];
    buf[0] = '\0';
    for(i=0; fname[i] != '\0' ; i++)
    {
	if( fname[i] == '/' && fname[i+1] != '\0' ){
	    
	    if(fname[i-1] == '.'){
		if(i-2 == -1 || fname[i-2] == '/' )
		    continue;/* ./acd or bb/./aaa ó */

		if(fname[i-2] == '.' ){
		    /* ../aaa or  adf/../aaa ó */
		    if( i-3 == -1 || fname[i-3] == '/' ){
			ptr -= 3;
			buf[ptr] = '\0';
			continue;
		    }
		}
	    }else 
		ptr += sprintf( buf + ptr, "../");
	}
    }
    return eStrdup( buf);
}
/*
   dir_name html_dirκ  ̹Ƿ ̵ΰ  ΰ ´.
 */
static char *get_absolute_dir( const char *const dir_name )
{
    char buf[BUF_MAX];

    sprintf( buf, "%s%s", html_dir, dir_name );
    return eStrdup( buf );
}

file_entry binary_file;

file_entry  *create_file_entry( const char *const fname, boolean I, boolean R )
{
    fileStatus *status;
    file_entry *entry;
    const char *file_extension;
    int len;
    char buf[BUF_MAX];


    status = eStat(fname);
    if( !status->isDirectory && is_binary(fname)){
	eStatFree(status);
	return &binary_file;
    }

    entry = xMalloc( 1 , file_entry );

    entry->status   = status;

    //html_dir   ̱  ùڰ / ü .
    Assert( fname[0] != '/' );

    //丮̸鼭  '/'  پ   ش.
    if( entry->status->isDirectory ){
	len = strlen(fname) - 1;
	if( fname[len] != '/' )
	    sprintf( buf, "%s/", fname );
	else
	    sprintf( buf, "%s", fname );

	/*丮 쿡 I R  */
	entry->is_I	    = I;
	entry->is_R	    = R;
    }
    else 
	sprintf( buf, "%s", fname );
    
    /*
        relativeFilename ̾   CurrentDirectory
        html_dir Ѵ.
     */

    entry->relative_fname = eStrdup( buf );
    entry->absolute_fname = get_absolute_dir(entry->relative_fname);

    entry->relative_dir = get_dir_name(entry->relative_fname);
    entry->path_upto_htmldir = get_path_upto_htmldir( entry->relative_fname );

    
#if 0
    fprintf( stdout, "\n\n fname:[%s]\tr_fname:[%s]\ndir:[%s] \t upto:[%s]\n absol:[%s] \n  ",
	    fname, entry->relative_fname , entry->relative_dir , 
	    entry->path_upto_htmldir , entry->absolute_fname);
#endif
   

    entry->next	    = NULL;

    file_extension  = fileExtension( fname );
    entry->language = get_lang_type_with_extension( file_extension );
    if( entry->language == Ignore )
	entry->language = get_lang_type_with_content(fname);
    if( is_ignore_list(entry->language))
	entry->language = Ignore;

    return entry;
}

extern void free_file_entry( file_entry *entry )
{
    eStatFree( entry->status );
    eFree( entry->relative_fname );
    eFree( entry->absolute_fname );
    eFree( entry->relative_dir );
    eFree( entry->path_upto_htmldir );
    eFree( entry );
}

void insert_file_entry( file_entry *entry)
{
    if( head == NULL )
    {
	head = entry;
	tail = entry;
    }
    else
    {
	tail->next = entry;
	tail = entry;
    }
}

file_entry *get_file_entry(void)
{
    file_entry *ret_entry;
    ret_entry = head;

    if( head != NULL )
	head  = head->next;

    if( option.v  && ret_entry != NULL ){
	printf("%s\n",ret_entry->relative_fname );
    }
   
    return ret_entry;
}

extern boolean is_exist_in_filelist( const char *const fname )
{
    file_entry *tmp;
    for( tmp = head ; tmp != NULL ; tmp = tmp->next )
    {
	if( isSameFile( fname, tmp->relative_fname ) )
	    return TRUE;
    }
    return FALSE;
}

void print_file_list(void)
{
    file_entry *tmp;
    for( tmp = head ; tmp != NULL ; tmp = tmp->next )
    {
	printf("language:%2d  I=%d R=%d  r_fname:%s  r_dir:%s  path_upto:%s\n\
		name:%s  is_dir:%d\n\n",
		tmp->language, tmp->is_I, tmp->is_R,
		tmp->relative_fname, tmp->relative_dir,tmp->path_upto_htmldir,
		tmp->status->name, tmp->status->isDirectory);
    }
}
