/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "routines.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

#include "makehtml.h"
#include "filelist.h"
#include "option.h"
#include "debug.h"
#include "taglist.h"

#include "htmlprocess.h"


static void write_uptodir_to_index(FILE *fd, const char *const dir_name  , const char *upto)
{
    switch( option.html_type ){
	case HtmlType:
	    fprintf( fd, "<a href=\"%s/%s\"><img src=\"%suptodir.ico\">../</a>\n", 
		    "..", idx_name, upto );
	    break;
	case CssType:
	    fprintf( fd, "<a href=\"%s/%s\"><img class=\"uptodir\" src=\"%suptodir.ico\">../</a>\n", 
		    "..", idx_name, upto);
	    break;
	case DhtmlType:
	    break;
    }
}

static void write_dir_to_index(FILE *fd, const char *const dir_name , const char *upto)
{
    const char *r_fname;
    r_fname = get_base_dir( dir_name );
    
    switch( option.html_type ){
	case HtmlType:
	    fprintf( fd, "<a href=\"%s/%s\"><img src=\"%sdir.ico\">%s/</a>\n", 
		    r_fname, idx_name,upto, r_fname );
	    break;

	case CssType:
	    fprintf( fd, "<a href=\"%s/%s\"><img class=\"directory\", src=\"%sdir.ico\">%s/</a>\n", 
		    r_fname, idx_name, upto, r_fname );
	    break;

	case DhtmlType:
	    break;
    }
}

static void write_file_to_index(FILE *fd, const char *const file_name , const char *upto)
{
    char name[BUF_MAX];
    char buf[BUF_MAX];

    buf[0] = '\0';
    name[0] = '\0'; 
    switch( option.html_type ){
	case HtmlType:
	    if( conf.is_source_exist )
		sprintf( buf, "%s target=\"source\" ",buf);
	    fprintf( fd, "<a %s href=\"%s\" %s><img src=\"%sfile.ico\">%s</a>\n", 
		    name, baseFilename(file_name), buf, upto, remove_html_ext(baseFilename(file_name)));
	    break;
	case CssType:
	    sprintf( name ," name = \"%s\" ", remove_html_ext(baseFilename(file_name)));
	    if( conf.is_source_exist )
		sprintf( buf, "%s target=\"source\" ", buf);
	    fprintf( fd, "<a %s href=\"%s\" %s><img class=\"file\" src=\"%sfile.ico\">%s</a>\n", 
		    name, baseFilename(file_name), buf, upto, remove_html_ext(baseFilename(file_name)));
	    break;
	case DhtmlType:
	    break;
    }
    
}


/*
   1 pass  ӽ  .
	a now_dir //link upto
	d dir_name
	f file_name
   2 pass   ǽ
   ̸  dir_index.html Ѵ.
*/
extern void idx_process( const char *dir_path)
{
    char    path[BUF_MAX];
    DIR	    *dir;	
    struct dirent   *file;
    int len;
    fileStatus	    *status=NULL;
    FILE *tmp_idx, *idx;
    char *tmp_fname = NULL , *ttmp_file=NULL;
    char  buf[BUF_MAX];
    static char  upto[BUF_MAX] = {0,};

    dir = opendir( dir_path );
    if( dir == NULL ) 
	error(FATAL, "open %s file error %s %d \n", tmp_fname,
		__FILE__ , __LINE__);

    tmp_fname = eStrdup(tempnam(dir_path,"code2html"));
    tmp_idx = fopen( tmp_fname, "a" );
    if( tmp_idx == NULL ) 
	error(FATAL, "open %s directory error %s %d \n", tmp_fname, __FILE__ , __LINE__);

    while( (file = readdir( dir )) != NULL)
    {
	if( file->d_name[0] == '.' ){
	    if( file->d_name[1] == '\0' ){
		continue;
	    }
	    else if( file->d_name[1] == '.' && file->d_name[2] == '\0' ){
		if( strcmp( dir_path , tmp_html_dir ) != 0 )
		    fprintf(tmp_idx,"a %s\n", dir_path );
		continue;
	    }
	}

	sprintf( path, "%s%s", dir_path, file->d_name);
	if( strcmp( path , tmp_fname) == 0 )
	    continue;

	status = eStat( path );
	Assert( status->exists );
	if( status->isDirectory ){
	    fprintf( tmp_idx,"d %s\n", path );
	    len = strlen( path );
	    path[len] = '/';
	    path[len+1] = '\0';

	    sprintf( upto , "%s../", upto);
	    idx_process(path); 
	}else{
	    fprintf( tmp_idx,"f %s\n", path );
	}
	eStatFree( status );
    }
    closedir( dir );
    fclose( tmp_idx );

    /* tmp_idx file    dir_index.html */
    ttmp_file = eStrdup(tempnam(dir_path,"code2html"));
    sprintf( buf,"sort -f %s > %s", tmp_fname, ttmp_file );
    if( system( buf) < 0 )
	error(FATAL, "system function error %s", buf);

    tmp_idx = fopen( ttmp_file, "r" );
    if( tmp_idx == NULL ) 
	error(FATAL, "open %s file error %s %d \n", tmp_fname, __FILE__ , __LINE__);
    sprintf( buf, "%s%s", dir_path, idx_name );
    idx	    = fopen( buf, "w" );

    switch( option.html_type ){
	case HtmlType:
	    fprintf( idx, "<html><head><title>%s</title></head>\n", dir_path);
	    fprintf( idx, "<body bgcolor=\"%s\">\n", conf.index_bg_color);
	    break;
	case CssType:
	    fprintf( idx, "<html><head><title>%s</title>\n", dir_path);
	    fprintf( idx, "<link rel=\"stylesheet\" type=\"text/css\" href=\"%sc2h.css\">" , upto);
	    fprintf( idx, "<script type=\"text/javascript\" src=\"layerHandler.js\"></script>");
	    fprintf( idx, "<script type=\"text/javascript\" src=\"folderHandler.js\"></script>");
	    fprintf( idx, "</head>\n");
	    break;
	case DhtmlType:
	    break;
    }

    fprintf( idx, "<pre>\n");
    font_begin( Index, conf.index_font_size, conf.index_font_color, conf.index_font_style, idx );
    while( (fgets(buf, BUF_MAX, tmp_idx )) != NULL  ){
	len = strlen(buf);
	buf[len-1]  = '\0';
	switch( buf[0] ){
	    case 'a':
		write_uptodir_to_index( idx, &buf[2] , upto); 
		break;
	    case 'd':
		write_dir_to_index( idx, &buf[2], upto );
		break;
	    case 'f':
		write_file_to_index( idx, &buf[2], upto );
		break;
	    default:
		Assert(FALSE);
	}
    }
    font_end(idx);
    fprintf( idx, "</pre>\n");
    fputs("</body></html>\n", idx);
    fclose( idx);
    fclose( tmp_idx );

#if 1
    if( unlink( tmp_fname ) < 0 )
	error( FATAL, "delete file error %s \n %s %d\n", 
		tmp_fname, __FILE__ , __LINE__ );
    if( unlink( ttmp_file ) < 0 )
	error( FATAL, "delete file error %s \n %s %d\n", 
		ttmp_file, __FILE__ , __LINE__ );
#endif
    eFree( tmp_fname );
    eFree( ttmp_file );

    len = strlen( upto );
    upto[ len - 3 ] = '\0';
}

/*
    c ==  d    directory
    c ==  f    file
    c ==  z    end
*/
static void write_dhtml_idx( const char *path, FILE *fout, char c )
{
    char buf[BUF_MAX];
    char *ptr;
    int len;

    len = strlen( tmp_html_dir );
    strcpy( buf, tmp_html_dir );
    buf[len-1] = '\0';
    if( strcmp( buf , path) == 0 )
	return ;

    strcpy( buf, path );
    ptr = (char*)get_base_dir( buf );
    *(ptr -1) = '\0';


    write_dhtml_idx( buf, fout, 'd');

    if( c == 'f' ){
	fprintf ( fout, "%c %s", c, remove_html_ext(ptr) );
    }else if( c == 'z' ){ 
	fprintf ( fout, "d %s/%c\n", ptr, c);
    }else{
	fprintf ( fout, "%c %s/", c, ptr );
    }
    return;
}

static void recursive_dhtml_idx_process( const char *dir_path , FILE *fout, const char *tmp_fname)
{
    DIR	    *dir;	
    int len;
    char    path[BUF_MAX];
    struct dirent   *file;
    fileStatus	    *status=NULL;
    char    *rel_path;

    dir = opendir( dir_path );

    if( dir == NULL ) 
	error(FATAL, "open %s file error %s %d \n", tmp_fname,
		__FILE__ , __LINE__);

    while( (file = readdir( dir )) != NULL)
    {
	if( file->d_name[0] == '.' ){
	    if( file->d_name[1] == '\0' ){
		continue;
	    }
	    else if( file->d_name[1] == '.' && file->d_name[2] == '\0' ){
		continue;
	    }
	}

	sprintf( path, "%s%s", dir_path, file->d_name);
	if( strcmp( path , tmp_fname) == 0 )
	    continue;

	status = eStat( path );
	Assert( status->exists );
	if( status->isDirectory ){

	    write_dhtml_idx( path, fout, 'd' );
	    rel_path = relativeFilename( path, tmp_html_dir );
	    fprintf(fout,":%sd\n",rel_path);
	    eFree( rel_path );

	    len = strlen( path );
	    path[len] = '/';
	    path[len+1] = '\0';

	    recursive_dhtml_idx_process(path, fout, tmp_fname); 
	}else{
	    write_dhtml_idx( path, fout, 'f' );
	    rel_path = relativeFilename( path, tmp_html_dir );
	    fprintf(fout,":%sf\n",rel_path);
	    eFree( rel_path );
	}
	eStatFree( status );
    }
    closedir( dir );
    //write_dhtml_idx( dir_path, fout, 'z' );
    strcpy( path, dir_path );
    len = strlen(path);
    path[len-1] = '\0';
    write_dhtml_idx( path, fout, 'z' );
}

extern void dhtml_idx_process( const char *dir_path)
{
    FILE *tmp_idx, *idx;
    char *tmp_fname = NULL , *ttmp_file=NULL;
    char  buf[BUF_MAX];
    //static char  upto[BUF_MAX] = {0,};
    char *ptr, *ptr2;
    int len;
    boolean flag = FALSE;

    tmp_fname = eStrdup(tempnam(dir_path,"code2html"));
    tmp_idx = fopen( tmp_fname, "w" );
    if( tmp_idx == NULL ) 
	error(FATAL, "open %s directory error %s %d \n", tmp_fname, __FILE__ , __LINE__);

    recursive_dhtml_idx_process( dir_path, tmp_idx , tmp_fname);

    fclose( tmp_idx );

    /* tmp_idx file    dir_index.html */
    ttmp_file = eStrdup(tempnam(dir_path,"code2html"));
    sprintf( buf,"sort -f %s > %s", tmp_fname, ttmp_file );
    if( system( buf) < 0 )
	error(FATAL, "system function error %s", buf);

    tmp_idx = fopen( ttmp_file, "r" );
    if( tmp_idx == NULL ) 
	error(FATAL, "open %s file error %s %d \n", tmp_fname, __FILE__ , __LINE__);
    sprintf( buf, "%s%s", dir_path, idx_name );
    idx	    = fopen( buf, "w" );

    fprintf( idx, "<html><head><title>%s</title>\n", dir_path); 
    fprintf( idx, "<link rel=\"stylesheet\" type=\"text/css\" href=\"c2h.css\">\n" ); 
    fprintf( idx, "<link rel=\"stylesheet\" type=\"text/css\" href=\"dhtml_dir.css\">\n" ); 
    fprintf( idx, "<script type=\"text/javascript\" src=\"layerHandler.js\"></script>\n");
    fprintf( idx, "<script type=\"text/javascript\" src=\"dhtml_dir.js\"></script>\n");
    fprintf( idx, "</head>\n");

    font_begin( Index, conf.index_font_size, conf.index_font_color, conf.index_font_style, idx );

    fprintf( idx, "<body onLoad=\"expandFolder( '%s' );\">\n", html_name );
    fprintf( idx, "<a class=\"folder\" href=\"javascript:toggleFolder( '%s' );\">\n", html_name );
    fprintf( idx, "<img class=\"dimg\" align=\"absmiddle\" id=\"ico:%s\" src=\"dir.ico\">%s</a><br>\n", 
	    html_name , html_name );
    fprintf( idx, "<div class=\"list\" id=\"div:%s\" style=\"display: none;\">\n", html_name );
    while( (fgets(buf, BUF_MAX, tmp_idx )) != NULL  ){
	len = strlen( buf );
	ptr = strchr( buf, ':' );

	if( ptr == NULL ){
	    fputs( "</div>\n", idx );
	    continue;
	}
	*ptr='\0';
	ptr2 = ptr;
	ptr++;
	while( *ptr2 != ' ' )
	    ptr2--;
	ptr2++;

	/*directory*/
	if( buf[len-2] == 'd' ){
	    buf[len-2] = '\0';
	    
	    fprintf( idx, "<a class=\"folder\" href=\"javascript:toggleFolder('%s%s/');\">\n",html_name, ptr );
	    fprintf( idx, "<img class=\"dimg\" align=\"absmiddle\" id=\"ico:%s%s/\" src=\"dir.ico\">%s</a><br>\n"
		    ,html_name, ptr, ptr2 ); 
	    fprintf( idx, "<div class=\"list\" id=\"div:%s%s/\" style=\"display: none;\">\n", html_name, ptr );
	}
	/*file*/
	else{
	    flag = TRUE;
	    buf[len-2] = '\0';
	    fprintf( idx, "<a class=\"source\" target=\"source\" href=\"%s\">%s</a><br>\n" , ptr, ptr2 );
	}
    }
    font_end(idx);
    fputs("</div></div></body></html>\n", idx);
    fclose( idx);
    fclose( tmp_idx );

#if 0
    if( unlink( tmp_fname ) < 0 )
	error( FATAL, "delete file error %s \n %s %d\n", 
		tmp_fname, __FILE__ , __LINE__ );
    if( unlink( ttmp_file ) < 0 )
	error( FATAL, "delete file error %s \n %s %d\n", 
		ttmp_file, __FILE__ , __LINE__ );
#endif
    eFree( tmp_fname );
    eFree( ttmp_file );
}


